# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("MatchData", "Object", "class")
aClass.addFragment(Paragraph.new("<code>MatchData</code> is the type of the special variable <code>$~</code>, and is the type of the object returned by <code>Regexp\#match</code> and <code>Regexp\#last_match</code>. It encapsulates all the results of a pattern match, results normally accessed through the special variables <code>$&</code>, <code>$'</code>, <code>$`</code>, <code>$1</code>, <code>$2</code>, and so on.\n"))
m0002 = MethodDesc.new("[]", "instance", "<i>mtch</i>[<i>i</i>] -> <i>anObject</i><br></br><i>mtch</i>[<i>start</i>, <i>length</i>] -> <i>anArray</i><br></br><i>mtch</i>[<i>aRange</i>] -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Match Reference---<code>MatchData</code> acts as an array, and may be accessed using the normal array indexing techniques. <i>mtch</i>[0] is equivalent to the special variable <code>$&</code>, and returns the entire matched string. <i>mtch</i>[1], <i>mtch</i>[2], and so on return the values of the matched backreferences (portions of the pattern between parentheses).\n"))
m0002.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm[0]       \#=> \"HX1138\"\nm[1, 2]    \#=> [\"H\", \"X\"]\nm[1..3]    \#=> [\"H\", \"X\", \"113\"]\nm[-3, 2]   \#=> [\"X\", \"113\"]\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("begin", "instance", "<i>mtch</i>.begin( <i>n</i> ) -> <i>anInteger</i>")
m0003.addFragment(Paragraph.new("Returns the offset of the start of the <em>n</em>th element of the match array in the string.\n"))
m0003.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.begin(0)   \#=> 1\nm.begin(2)   \#=> 2\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("end", "instance", "<i>mtch</i>.end( <i>n</i> ) -> <i>anInteger</i>")
m0004.addFragment(Paragraph.new("Returns the offset of the character immediately following the end of the <em>n</em>th element of the match array in the string.\n"))
m0004.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.end(0)   \#=> 7\nm.end(2)   \#=> 3\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("length", "instance", "<i>mtch</i>.length -> <i>anInteger</i>")
m0005.addFragment(Paragraph.new("Returns the number of elements in the match array.\n"))
m0005.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.length   \#=> 5\nm.size     \#=> 5\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("offset", "instance", "<i>mtch</i>.offset( <i>n</i> ) -> <i>anArray</i>")
m0006.addFragment(Paragraph.new("Returns a two-element array containing the beginning and ending offsets of the <em>n</em>th match.\n"))
m0006.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.offset(0)   \#=> [1, 7]\nm.offset(4)   \#=> [6, 7]\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("post_match", "instance", "<i>mtch</i>.post_match -> <i>aString</i>")
m0007.addFragment(Paragraph.new("Returns the portion of the original string after the current match. Equivalent to the special variable <code>$'</code>.\n"))
m0007.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138: The Movie\")\nm.post_match   \#=> \": The Movie\"\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("pre_match", "instance", "<i>mtch</i>.pre_match -> <i>aString</i>")
m0008.addFragment(Paragraph.new("Returns the portion of the original string before the current match. Equivalent to the special variable <code>$`</code>.\n"))
m0008.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.pre_match   \#=> \"T\"\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("size", "instance", "<i>mtch</i>.size -> <i>anInteger</i>")
m0009.addFragment(Paragraph.new("A synonym for <code>MatchData\#length</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("string", "instance", "<i>mtch</i>.string -> <i>aString</i>")
m0010.addFragment(Paragraph.new("Returns a frozen copy of the string passed in to <code>match</code>.\n"))
m0010.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.string   \#=> \"THX1138.\"\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("to_a", "instance", "<i>mtch</i>.to_a -> <i>anArray</i>")
m0011.addFragment(Paragraph.new("Returns the array of matches.\n"))
m0011.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.to_a   \#=> [\"HX1138\", \"H\", \"X\", \"113\", \"8\"]\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("to_s", "instance", "<i>mtch</i>.to_s -> <i>aString</i>")
m0012.addFragment(Paragraph.new("Returns the entire matched string.\n"))
m0012.addFragment(Verbatim.new("m = /(.)(.)(\\d+)(\\d)/.match(\"THX1138.\")\nm.to_s   \#=> \"HX1138\"\n"))
aClass.addMethod(m0012)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
