/*
 * Header of the proxy around Rhythmbox's Bonobo interface.
 *
 * Rhythmbox Applet
 * Copyright (C) 2004-2005 Paul Kuliniewicz <kuliniew@purdue.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef RB_PROXY_H
#define RB_PROXY_H

#include <glib-object.h>

#include "Rhythmbox.h"		/* for GNOME_Rhythmbox_SongInfo */

#define RB_TYPE_PROXY		rb_proxy_get_type ()
#define RB_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_CAST ((o), RB_TYPE_PROXY, RbProxy))
#define RB_PROXY_CLASS(k) 	(G_TYPE_CHECK_CLASS_CASE ((k), RB_TYPE_PROXY, RbProxyClass))
#define RB_IS_PROXY(o) 		(G_TYPE_CHECK_INSTANCE_TYPE ((o), RB_TYPE_PROXY))
#define RB_PROXY_GET_CLASS(o) 	(G_TYPE_INSTANCE_GET_CLASS ((o), RB_TYPE_PROXY, RbProxyClass))

typedef GNOME_Rhythmbox_SongInfo RbProxySongInfo;

typedef struct RbProxyPrivate RbProxyPrivate;

typedef struct
{
	GObject parent;

	/*< private >*/

	RbProxyPrivate *priv;
} RbProxy;

typedef struct
{
	GObjectClass parent_class;

	/*< signals >*/

	void (*song_changed) (RbProxy *proxy, const RbProxySongInfo *song);
	void (*playing_changed) (RbProxy *proxy, gboolean playing);
	void (*connection_changed) (RbProxy *proxy, gboolean connected);
	void (*time_updated) (RbProxy *proxy, glong play_time);
} RbProxyClass;

GType rb_proxy_get_type (void);

RbProxy *rb_proxy_new (void);

void rb_proxy_play_pause_stop (RbProxy *proxy);
void rb_proxy_previous (RbProxy *proxy);
void rb_proxy_next (RbProxy *proxy);
void rb_proxy_rate_current (RbProxy *proxy, double score);

RbProxySongInfo *rb_proxy_get_song_info (RbProxy *proxy);
glong rb_proxy_get_play_time (RbProxy *proxy);
gboolean rb_proxy_is_playing (RbProxy *proxy);
gboolean rb_proxy_is_pausable (RbProxy *proxy);
gboolean rb_proxy_is_connected (RbProxy *proxy);

void rb_proxy_song_info_free (RbProxySongInfo *song);

#endif /* RB_PROXY_H */
