/*
 *  Copyright (C) 1999
 *  Robert Lissner
 *  Jay MacDonald
 *  Sam Phillips
 *  Keith Wesolowski. 
 */

/* Current owner: Keith */

#include "includes.h"
#include "globals.h"

#define row_is_visible(trow) (GTK_SHEET (front->sheet)->row [trow].is_visible)

static GtkWidget *match_entry, *case_sensitive_check;

/* for Tools Menu */

void tools_find (GtkWidget *w, gpointer *data) {

     GtkWidget *find_dialog,
	*ok_button,
	*cancel_button,
	*hbox;

    /* Manipulates some globals to give us a unified dialog box */
     if (check_if_changed ())
       return;
     make_basic_dialog1 ();
    find_dialog = dialog1_win;

    gtk_window_set_title (GTK_WINDOW (find_dialog), _("Find next"));
    gtk_signal_connect_object (GTK_OBJECT (find_dialog), "destroy",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (find_dialog));

    ok_button = gtk_button_new_with_label (_("  OK  "));
    gtk_widget_set_name (ok_button, "Find OK");
    gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			GTK_SIGNAL_FUNC (_tools_button_clicked), find_dialog);

    cancel_button = gtk_button_new_with_label (_("  Cancel  "));
    gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (find_dialog));

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->action_area),
			ok_button, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->action_area),
			cancel_button, FALSE, FALSE, 0);

    gtk_widget_show (ok_button);
    gtk_widget_show (cancel_button);

    match_entry = gtk_entry_new ();
    gtk_widget_set_name (match_entry, "Find OK");
    gtk_signal_connect (GTK_OBJECT (match_entry), "activate",
			GTK_SIGNAL_FUNC (_tools_button_clicked), NULL);
    gtk_widget_show (match_entry);

    if (front->current_compare)
	gtk_entry_set_text (GTK_ENTRY (match_entry), front->current_compare);

    case_sensitive_check = gtk_check_button_new_with_label
	(_("Case sensitive"));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (case_sensitive_check),
				  FALSE);
    gtk_widget_set_sensitive (case_sensitive_check, TRUE);
    gtk_widget_show (case_sensitive_check);

    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), match_entry, TRUE, TRUE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), case_sensitive_check, TRUE, TRUE, 5);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (find_dialog)->vbox), hbox,
			TRUE, TRUE, 5);

    gtk_widget_grab_focus (match_entry);
    gtk_widget_show (find_dialog);
}

void tools_match (GtkWidget *w, gpointer *data) {
    GtkWidget *match_dialog,
	*ok_button,
	*cancel_button,
	*reset_button,
	*hbox;
    
    if (check_if_changed ())
       return;
   make_basic_dialog1 ();
    match_dialog = dialog1_win;

    gtk_window_set_title (GTK_WINDOW (match_dialog), _("Match with"));
    gtk_signal_connect_object (GTK_OBJECT (match_dialog), "destroy",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (match_dialog));

    ok_button = gtk_button_new_with_label (_("  OK  "));
    gtk_widget_set_name (ok_button, "Match OK");
    gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
			GTK_SIGNAL_FUNC (_tools_button_clicked), match_dialog);

    cancel_button = gtk_button_new_with_label (_("  Cancel  "));
    gtk_signal_connect_object (GTK_OBJECT (cancel_button), "clicked",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (match_dialog));

    reset_button = gtk_button_new_with_label (_("  Show All  "));
    gtk_widget_set_name (reset_button, "Match Reset");
    gtk_signal_connect (GTK_OBJECT (reset_button), "clicked",
			GTK_SIGNAL_FUNC (_tools_button_clicked), match_dialog);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
			ok_button, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
			reset_button, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->action_area),
			cancel_button, FALSE, FALSE, 0);

    gtk_widget_show (ok_button);
    gtk_widget_show (reset_button);
    gtk_widget_show (cancel_button);

    match_entry = gtk_entry_new ();
    gtk_widget_set_name (match_entry, "Match OK");
    gtk_signal_connect (GTK_OBJECT (match_entry), "activate",
			GTK_SIGNAL_FUNC (_tools_button_clicked), match_dialog);
    gtk_widget_show (match_entry);

    if (front->current_compare)
	gtk_entry_set_text (GTK_ENTRY (match_entry), front->current_compare);

    case_sensitive_check = gtk_check_button_new_with_label
	(_("Case sensitive"));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (case_sensitive_check),
				  FALSE);
    gtk_widget_set_sensitive (case_sensitive_check, TRUE);
    gtk_widget_show (case_sensitive_check);

    hbox = gtk_hbox_new (FALSE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), match_entry, TRUE, TRUE, 5);
    gtk_box_pack_start (GTK_BOX (hbox), case_sensitive_check, TRUE, TRUE, 5);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (match_dialog)->vbox), hbox,
			TRUE, TRUE, 5);

    gtk_widget_grab_focus (match_entry);
    gtk_widget_show (match_dialog);
}


void help_credits (GtkWidget *w, gpointer *data) {
    GtkWidget *credits_dialog,
	*ok_button,
	*label1, *label2, *label3, *label4, *label5, *label6, *label7,
	*label8, *label9;

     if (check_if_changed ())
       return;
     make_basic_dialog1 ();
    credits_dialog = dialog1_win;

    gtk_signal_connect_object (GTK_OBJECT (credits_dialog), "destroy",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (credits_dialog));

    ok_button = gtk_button_new_with_label (_("  OK  "));
    gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			       GTK_SIGNAL_FUNC (cancel_level1),
			       GTK_OBJECT (credits_dialog));
 
    label1 = gtk_label_new (_("QuickList version " VERSION));
    label2 = gtk_label_new (_("Copyright (c) 1999 the QuickList team:"));
    label3 = gtk_label_new (_(" "));
    label4 = gtk_label_new (_("Jay MacDonald <jay@aztech-cs.com>"));
    label5 = gtk_label_new (_("Sam Phillips <sam@QuickList.org>"));
    label6 = gtk_label_new (_("Keith Wesolowski <theman@cs.unr.edu>"));
    label7 = gtk_label_new (_("  Special thanks to Adrian E. Feiguin <adrian@ifir.ifir.edu.ar> for GtkSheet.  "));
    label8 = gtk_label_new (_("Please send all inquiries to bugs@QuickList.org"));
    label9 = gtk_label_new (_("-or- visit http://www.QuickList.org for more information."));

     gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->action_area),
			ok_button, FALSE, FALSE, 5);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label1, FALSE, FALSE, 5);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label2, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label3, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label4, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label5, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label6, FALSE, FALSE, 1);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label7, FALSE, FALSE, 5);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label8, FALSE, FALSE, 5);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (credits_dialog)->vbox),
			label9, FALSE, FALSE, 0);
    gtk_widget_show_all (credits_dialog);
}

/* This is our basic action handler for match and find (credits actions are
 * handled by the level1 functions). We rely on widget names to indicate what
 * we should do.
 */
void _tools_button_clicked (GtkWidget *w, gpointer *data) {
    if (!strcmp ("Find OK", gtk_widget_get_name (w))) {
	gchar *match_string = gtk_entry_get_text (GTK_ENTRY (match_entry));
	if (front->current_compare) g_free (front->current_compare);
	front->current_compare = g_strdup (match_string);
	if (!_tools_find_text (match_string))
	    level2_error (_("  Nothing found  "), _("  OK  "));
    } else if (!strcmp ("Match OK", gtk_widget_get_name (w))) {
	gchar *match_string = gtk_entry_get_text (GTK_ENTRY (match_entry));
	if (front->current_compare) g_free (front->current_compare);
	front->current_compare = g_strdup (match_string);
	_tools_match_text (match_string);
	cancel_level1 ((GtkWidget*) data, NULL, NULL);
    } else if (!strcmp ("Match Reset", gtk_widget_get_name (w))) {
	_tools_match_text ("");
	cancel_level1 ((GtkWidget*) data, NULL, NULL);
    }
}

gboolean _tools_find_text (gchar *search) {
    gchar *entry;
    gchar *low_entry = NULL;
    gboolean doing_nocase;
    gint32 i, j;
    gint32 start_selection = GTK_SHEET (front->sheet)->range.row0;

    if (!search)
	return FALSE;
    
    if ((doing_nocase = !gtk_toggle_button_get_active
	 (GTK_TOGGLE_BUTTON (case_sensitive_check))))
	g_strdown (search);

    for (i=1; i <= front->last_row; i++)
	for (j=0; j <= front->last_field; j++) {
	    entry = (gchar*) gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
						      (start_selection+i)
						      % front->last_row, j);
	    if (entry) {
		if (doing_nocase)
		    g_strdown (low_entry = g_strdup (entry));
		if (strstr ((doing_nocase ? low_entry : entry), search)
		    && row_is_visible ((start_selection+i)
				       % (front->last_row))) {
		    gtk_sheet_select_row (GTK_SHEET (front->sheet),
					  (start_selection+i)
					  % (front->last_row));
		    gtk_sheet_moveto (GTK_SHEET (front->sheet),
				      GTK_SHEET (front->sheet)->range.row0,
				      0, 0.0, 0.0);
		    if (doing_nocase) g_free (low_entry);
		    return TRUE;
		}
		if (doing_nocase) g_free (low_entry);
	    }
	}
    return FALSE;
}

void _tools_match_text (gchar *search) {
    gchar *entry, *low_entry = NULL;
    gint32 i, j;
    gboolean doing_nocase;
    
    if ((doing_nocase = !gtk_toggle_button_get_active
	 (GTK_TOGGLE_BUTTON (case_sensitive_check))))
	g_strdown (search);

    /* We don't want to match against already-filtered records */
    big_draw_start ();

    for (i=0; i < front->last_row; i++)
	gtk_sheet_row_set_visibility (GTK_SHEET (front->sheet), i, TRUE);
    front->filter_ptr = NULL;

    gtk_sheet_unselect_range (GTK_SHEET (front->sheet),
			      &(GTK_SHEET (front->sheet)->range));
    for (i=0; i < front->last_row; i++) {
	gtk_sheet_row_set_visibility (GTK_SHEET (front->sheet), i, FALSE);
	for (j=0; j <= front->last_field; j++) {
	    entry = (gchar*) gtk_sheet_cell_get_text (GTK_SHEET (front->sheet),
						      i, j);
	    if (entry) {
		if (doing_nocase)
		    g_strdown (low_entry = g_strdup (entry));
		if (strstr (doing_nocase ? low_entry : entry, search))
		    gtk_sheet_row_set_visibility (GTK_SHEET (front->sheet),
						  i, TRUE);
		g_free (low_entry);
	    }
	}
    }
    big_draw_end ();
}
