/*
 * QStereoCtrl.h
 * $Id: QStereoCtrl.h,v 1.3 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

#ifndef QSTEREODLG_H
#define QSTEREODLG_H

#include <qwidget.h>
#include <qcheckbox.h>
#include <qlcdnumber.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qslider.h>
#include <qcombobox.h>

class QGLViewer;

class QStereoCtrl : public QWidget
{
  Q_OBJECT

    public:
  
  enum StereoType {
    TYPE1,    
    TYPE2
  };


  /** constructor */
  QStereoCtrl( QGLViewer *pViewer, const char * name=0 );

  /** destructor */
  ~QStereoCtrl( void );


public slots:

 void sltAngleChanged( int value );
 void sltStereoTypeChanged( int type );

 signals:

 void sigApply( void );

private:

 void initDlg(void);
 void setValues( int type, float parallaxAngle );
 void setStereoType( int index );
 void setAngle(float);
 void activateStereoFrustum(int dir);

 public:

 void activateLeftStereoFrustum(void);
 void activateRightStereoFrustum(void);
 void showDlg( void );
 void hideDlg( void );

 private:

 QGLViewer     *m_pViewer;
 QComboBox     *m_pTypeCombo;
 QSlider       *m_pAngleSlider;
 float          m_maxAllowedAngle;
 float          m_parallaxAngle;
 int            m_stereoType;
 bool           m_createDlg;

};


#endif // QSTEREODLG_H







