#this program corresponds to special.py
import os
#import fpformat
import unittest
import sys
from unittest import TestCase
import scipy_base.limits as limits
from scipy_test.testing import *
set_package_path()
import scipy.signal as signal
del sys.path[0]

from Numeric import array

class test_convolve(TestCase):
    def check_basic(self):
        a = [3,4,5,6,5,4]
        b = [1,2,3]
        c = signal.convolve(a,b)
        assert_array_equal(c,array([3,10,22,28,32,32,23,12]))

class test_medfilt(TestCase):
    def check_basic(self):
        f = [[3,4,5],[2,3,4],[1,2,5]]
        d = signal.medfilt(f)
        assert_array_equal(d, [[0,3,0],[2,3,3],[0,2,0]])

class test_wiener(TestCase):
    def check_basic(self):
        g = array([[5,6,4,3],[3,5,6,2],[2,3,5,6],[1,6,9,7]],'d')
        correct = array([[2.16374269,3.2222222222, 2.8888888889, 1.6666666667],[2.666666667, 4.33333333333, 4.44444444444, 2.8888888888],[2.222222222, 4.4444444444, 5.4444444444, 4.801066874837],[1.33333333333, 3.92735042735, 6.0712560386, 5.0404040404]])
        h = signal.wiener(g)
        assert_array_almost_equal(h,correct,decimal=6)

if __name__ == "__main__":
    ScipyTest(signal).run()






