# 
# Prospect: a developer's system profiler.
# System Tests: symbol discrimination.
#
# COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
#
# Author: Bob Montgomery, HP
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place - Suite 330, Boston, MA 02111-1307, USA.
#

# $Id: checksyms.awk,v 1.5 2004/01/09 20:29:28 type2 Exp $

{
    if (NF == 0) {
        ; #ignore empty lines
    } else if ($1 == "fact_command") {
        cmdname = $2;
        cmdline = substr($0,length($1)+2)
    } else if ($1 == "fact_description") {
        printf "********************************************************\n";
        printf "Checking symbols: %s\n", substr($0, length($1)+2);
    } else if ($1 == "fact_dynamic_syms") {
        dynamic_syms = 1;
    } else if ($1 == "fact_frequency") {
        freq = $2;
    } else if ($1 == "fact_user_time") {
        user_time = $2;
    } else if ($1 == "fact_sys_time") {
        sys_time = $2;
    } else if ($1 == "fact_good_sym_pat") {
        good_sym_pat = $2;
    } else if ($1 == "fact_bad_sym_pat") {
        bad_sym_pat = $2;
    } else if ($1 == "fact_subs_count") {
        subs_count = $2;
        good_subs_count = $2/2;
        bad_subs_count = $2/2;
    } else if ($0 ~ "==---") {
        after = 1;
    } else { 
        if ($0 ~ bad_sym_pat) {
            # Will need to qualify this on stripped shared lib test
            if (dynamic_syms && ($5 ~ "->"bad_sym_pat)) {
                ;  # This is Okay
            } else {
                printf "ERROR (%d): samples in uncalled subroutine: \n\t%s\n", 
                        NR, $5;
                error++;
            }
        }
        if ($0 ~ good_sym_pat) {
            if (($5 ~ good_sym_pat) && ($5 !~ "->"good_sym_pat)) {
                psubs_count++;
            } else {
                printf "ERROR (%d): symbol %s unexpected in line:\n%s\n", 
                    NR, good_sym_pat, $0;
                error++;
            }
        }
    }
}

END {
    if (psubs_count != good_subs_count) {
        printf "ERROR (%d): subroutine counts differ: expected %d, got %d\n", 
            NR, good_subs_count, psubs_count;
        error++;
    }
    if (error) {
        printf "Check complete with %d errors\n", error;
    } else {
        printf "Check complete -> OK\n";
    }
    exit error;
}

