/***************************************************************************
                          lvi_cddrive.cpp  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_cddrive.h"

#include <qpixmap.h>
#include <qimage.h>

#include "gui.h"

LVI_CDDrive::LVI_CDDrive(QListView *parent, int _driveID, QString _path, QString _device, bool _isSuperMounted)
	: QListViewItem(parent), driveID(_driveID), isSuperMounted(_isSuperMounted), path(_path), device(_device) 
{
	name.sprintf(_("CDROM %d"), driveID);
	applyUnmount();
	isLocked = false;
	isKnown = false;
}
	
void LVI_CDDrive::lock(QString comment)
{
	isLocked = true;
	setText(0, name + " [" + comment + "...]");
}
	
void LVI_CDDrive::unlock()
{
	isLocked = false;
	setText(0, name + " [" + label + "]");
}
	
void LVI_CDDrive::applyMount(unsigned checksum)
{
	isMounted = true;
	this->checksum = checksum;
	setPixmap(0, QPixmap(PROKYON_HOME + "/images/lvi_cdrom.png"));
}


void LVI_CDDrive::applyUnmount()
{
	isMounted = false;
	cdID      = 0;
	checksum  = 0;
	setText(0, name);
	setPixmap(0, GUI::fadeOutIcon(PROKYON_HOME + "/images/lvi_cdrom.png"));
}
	
void LVI_CDDrive::applyInfo(bool isKnown, QString label, int cdID)
{
	this->isKnown = isKnown;
	this->cdID = cdID;
	this->label = label;
	setText(0, name + " [" + label + "]");
}

