/***************************************************************************
                          jobmanager.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "jobmanager.h"

#include "gui.h"

#include "job_synchronizewithdatabase.h"

JobManager::JobManager()
{
  job_connect_isRunning = false;
  job_disconnect_isRunning = false;
  job_query_isRunning = false;
  job_modify_isRunning = false;
  job_generate_isRunning = false;
  jobCounter = 0;
}

JobManager::~JobManager()
{
  deleteFinishedJobs();
}

void JobManager::addJob(JobBase *job)
{
  Job_SynchronizeWithDatabase *syncjob;
  deleteFinishedJobs();
  bool success = false;
  switch(job->type()) {
  case JOB_CONNECT_TO_DATABASE:
    if(job_connect_isRunning) delete job;
    else {
      success = true;
      job_connect_isRunning = true;
    }
    break;
  case JOB_DISCONNECT_FROM_DATABASE:
    if(job_disconnect_isRunning) delete job;
    else {
      success = true;
      job_disconnect_isRunning = true;
    }
    break;
  case JOB_MODIFY_FAVOURITE:
    success = true;
    break;
  case JOB_SYNCHRONIZE_WITH_DATABASE:
    syncjob = static_cast<Job_SynchronizeWithDatabase*>(job);
    if(job_synchronize_isRunning.contains(syncjob->getMediumID()) && job_synchronize_isRunning[syncjob->getMediumID()]) delete job;
    else {
      success = true;
      job_synchronize_isRunning[syncjob->getMediumID()] = true;
    }
    break;
  case JOB_QUERY_DATABASE:
  case JOB_QUERY_PLAYLIST_TRACKS:
    if(job_query_isRunning) delete job;
    else {
      success = true;
      job_query_isRunning = true;
    }
    break;
  case JOB_MODIFY_TRACKS_IN_DATABASE:
  case JOB_MODIFY_PLAYLISTS:
  case JOB_MODIFY_PLAYLIST_TRACKS:
    if(job_modify_isRunning) delete job;
    else {
      success = true;
      job_modify_isRunning = true;
    }
    break;
  case JOB_COMPUTE_CDROM_ID:
    success = true;
    break;
  case JOB_APPEND_CDROM_TO_DATABASE:
    success = true;
    break;
  case JOB_DELETE_MEDIUM_FROM_DATABASE:
    success = true;
    break;
  case JOB_APPEND_SMB_TO_DATABASE:
    success = true;
    break;
  case JOB_APPEND_NFS_TO_DATABASE:
    success= true;
    break;
  case JOB_DELETE_TRACK_PHYSICALLY:
    success = true;
    break;
  case JOB_COUNT_DATA:
    success = true;
    break;
  case JOB_GENERATE_PLAYLIST:
    if(job_generate_isRunning) delete job;
    else {
      success = true;
      job_generate_isRunning = true;
    }
    break;
  }
  if(success) {
    jobList.append(job);
    job->start();
    incrJobCounter();
  }
}

void JobManager::jobDone(JobBase *job)
{
  Job_SynchronizeWithDatabase *syncjob;
  switch(job->type()) {
  case JOB_CONNECT_TO_DATABASE:
    job_connect_isRunning = false;
    break;
  case JOB_DISCONNECT_FROM_DATABASE:
    job_disconnect_isRunning = false;
    break;
  case JOB_MODIFY_FAVOURITE:
    break;
  case JOB_SYNCHRONIZE_WITH_DATABASE:
    syncjob = static_cast<Job_SynchronizeWithDatabase*>(job);
    job_synchronize_isRunning[syncjob->getMediumID()] = false;
    break;
  case JOB_QUERY_DATABASE:
  case JOB_QUERY_PLAYLIST_TRACKS:
    job_query_isRunning = false;
    break;
  case JOB_MODIFY_TRACKS_IN_DATABASE:
  case JOB_MODIFY_PLAYLISTS:
  case JOB_MODIFY_PLAYLIST_TRACKS:
    job_modify_isRunning = false;
    break;
  case JOB_COMPUTE_CDROM_ID:
    break;
  case JOB_APPEND_CDROM_TO_DATABASE:
    break;
  case JOB_DELETE_MEDIUM_FROM_DATABASE:
    break;
  case JOB_APPEND_SMB_TO_DATABASE:
    break;
  case JOB_APPEND_NFS_TO_DATABASE:
    break;
  case JOB_DELETE_TRACK_PHYSICALLY:
    break;
  case JOB_COUNT_DATA:
    break;
  case JOB_GENERATE_PLAYLIST:
    job_generate_isRunning = false;
    break;
  }
  decrJobCounter();
}

void JobManager::incrJobCounter()
{
	QString statustext;
	jobCounter++;
	statustext.sprintf(_(" Jobs: %d "), jobCounter);
	app->lock();
	gui->setStatusInfo(statustext, 1);
	app->unlock();
}

void JobManager::decrJobCounter()
{
	QString statustext;
	jobCounter--;
	statustext.sprintf(_(" Jobs: %d "), jobCounter);
	app->lock();
	gui->setStatusInfo(statustext, 1);
	app->unlock();
}

void JobManager::deleteFinishedJobs()
{
	for(JobBase *curr = jobList.first(); curr != 0; curr = jobList.next()) {
		if(curr->finished()) {
			jobList.remove(curr);
			delete curr;
		}
	}
}
