/***************************************************************************
                    database_create_dialog.cpp  -  description
                             -------------------
    begin                : Sun Feb 10 2001
    copyright            : (C) 2002 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "database_create_dialog.h"

#include "database.h"
#include "configuration.h"

#include <qvbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qsqlquery.h>
#include <qsqlerror.h>
#include <qmessagebox.h>
	
Database_Create_Dialog::Database_Create_Dialog(QWidget *parent, const char *name)
    : QDialog(parent, name, true)
{
	QVBoxLayout *lay = new QVBoxLayout(this);	
    
    QGroupBox *hostbox = new QGroupBox(1, Qt::Horizontal, _("Database Server"), this);
    QFrame *hostboxf = new QFrame(hostbox); 
    QGridLayout *hostlay = new QGridLayout(hostboxf, 1, 2);

    QLabel *aa = new QLabel(_("<b>Host: </b>"), hostboxf); aa->setAlignment(Qt::AlignRight);
    hostlay->addWidget(aa, 0, 0);
	host_line = new QLineEdit("localhost", hostboxf);
	hostlay->addWidget(host_line, 0, 1);
 
	lay->addWidget(hostbox);

    QGroupBox *userbox = new QGroupBox(1, Qt::Horizontal, _("Database Superuser"), this);
    QFrame *userboxf = new QFrame(userbox); 
    QGridLayout *userlay = new QGridLayout(userboxf, 2, 2);

    QLabel *a1 = new QLabel(_("<b>User: </b>"), userboxf); a1->setAlignment(Qt::AlignRight);
    userlay->addWidget(a1, 0, 0);
	su_line = new QLineEdit("root", userboxf);
	userlay->addWidget(su_line, 0, 1);
    QLabel *b1 = new QLabel(_("<b>Pass: </b>"), userboxf); b1->setAlignment(Qt::AlignRight);
    userlay->addWidget(b1, 1, 0);
	supass_line = new QLineEdit("", userboxf);
	userlay->addWidget(supass_line, 1, 1);
  
	lay->addWidget(userbox);

	QGroupBox *dbbox = new QGroupBox(1, Qt::Horizontal, _("New Database Settings"), this);
    QFrame *dbboxf = new QFrame(dbbox); 
    QGridLayout *dblay = new QGridLayout(dbboxf, 3, 2);

	
    QLabel *b = new QLabel(_("<b>Database: </b>"), dbboxf); b->setAlignment(Qt::AlignRight);
    dblay->addWidget(b, 0, 0);
	db_line = new QLineEdit("prokyon", dbboxf);
	dblay->addWidget(db_line, 0, 1);
     QLabel *c = new QLabel(_("<b>User: </b>"), dbboxf); c->setAlignment(Qt::AlignRight);
    dblay->addWidget(c, 1, 0);
	user_line = new QLineEdit("prokyon", dbboxf);
	dblay->addWidget(user_line, 1, 1);
     QLabel *d = new QLabel(_("<b>Pass: </b>"), dbboxf); d->setAlignment(Qt::AlignRight);
    dblay->addWidget(d, 2, 0);
	pass_line = new QLineEdit("prokyon", dbboxf);
	dblay->addWidget(pass_line, 2, 1);
 
	lay->addWidget(dbbox);

	
	QHBox *butbox = new QHBox(this);

	QPushButton *createbutton = new QPushButton(_("Create"), butbox);
	QPushButton *cancelbutton = new QPushButton(_("Cancel"), butbox);	
	
    connect(createbutton, SIGNAL(clicked()), this, SLOT(slot_create()));
    connect(cancelbutton, SIGNAL(clicked()), this, SLOT(slot_cancel()));

	lay->addWidget(butbox);
}

void Database_Create_Dialog::slot_create() {
    QString result = database->createNewDatabase(host_line->text(), db_line->text(), user_line->text(), pass_line->text(), su_line->text(), supass_line->text());
    result = result.stripWhiteSpace();
    if(result == "") result = "SUCCESS"; QMessageBox::information(this, _("Message"), _("Database Result: ") + result, QMessageBox::Ok);
    if(result == "SUCCESS") {
	config->db_host = host_line->text();
	config->db_database = db_line->text();
	config->db_user = user_line->text();
	config->db_pass = pass_line->text();
	accept();
    }
}

void Database_Create_Dialog::slot_cancel() {
    reject();
}

Database_Create_Dialog::~Database_Create_Dialog()
{}
	
