/***************************************************************************
                          database.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASE_H
#define DATABASE_H

#include "prokyon.h"

#include <qthread.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qmap.h>

class DataBase {
 public:
  DataBase() {}
  
  void lock() { mutex.lock(); }
  void unlock() { mutex.unlock(); }
  
  virtual void establishConnection(QString host, QString db, QString user, QString pass) = 0;
  
    virtual QString createNewDatabase(QString host, QString db, QString user, QString pass, QString su, QString su_pass) = 0;

  virtual QList<ARTISTALBUM> *getSamplerBasis() = 0;
  virtual QList<ARTISTALBUM> *getFavouritesBasis() = 0;
  virtual QList<ARTISTALBUM> *getArtistAlbumBasis() = 0;
  virtual QList<MEDIUM> *getMediumBasis() = 0;
  virtual QList<PLAYLIST> *getPlaylistBasis() = 0;
  virtual QList<PLAYLIST_TRACK> *getPlaylistTracksBasis(int playlistID) = 0;

  virtual void generatePlaylist(int playlistID, int numberTracks, int minTrackLength, int maxTrackLength, bool onlyFavouriteArtists) = 0;

  virtual QMap<int, QMap<int, DELTAINFO*> > *getArtistDelta() = 0;
  virtual QMap<int, QMap<int, int> > *getLocalDeltaBasis() = 0;
  virtual QMap<int, int> getLocalDelta(int id) = 0;
  virtual QMap<int, QMap<QString, int> > *getLocalAlbumDeltaBasis() = 0;
  virtual QMap<QString, int> getLocalAlbumDelta(int id) = 0;
  
  virtual int appendTracks(QList<TRACK> *tracklist, int mediumtype, QString mediumlabel, QString mediumpath, unsigned mediumchecksum, bool createNewMedium, int mediumID) = 0;
  virtual void updateTracks(QList<TRACK> *tracklist) = 0;
  virtual void deleteTracks(QList<TRACK> *tracklist) = 0;

  virtual int appendPlaylist(QString listname) = 0;
  virtual void renamePlaylist(int id, QString newname) = 0;
  virtual void deletePlaylist(int id) = 0;

  virtual int appendPlaylistTracks(QList<TRACK> *tracklist, int playlistID, int *position) = 0;
  virtual void deletePlaylistTracks(QList<TRACK> *tracklist) = 0;
  virtual void deletePlaylistTracks(QList<PLAYLIST_TRACK> *playlist_tracklist) = 0;
  virtual void updatePlaylistTrack(int playlistID, int trackID, int new_pos) = 0;
  
  virtual void deleteMedium(int id) = 0;

  virtual void modifyFavouriteArtist(int, bool) = 0;

  virtual int getCountFromTable(QString) = 0;
  virtual int getCountColumnDistinctFromTable(QString, QString) = 0;

  virtual QList<TRACK> *getTracksByMedium(int id) = 0;
  
  virtual QList<TRACK> *queryTracksByMedium(int id) = 0;
  virtual QList<TRACK> *queryTracksByArtist(int id) = 0;
  virtual QList<TRACK> *queryTracksByArtistAlbum(QString artist, QString album) = 0;
  virtual QList<TRACK> *queryTracksByAlbum(QString sampler, QString album) = 0;
  virtual QList<TRACK> *queryTracksByPlaylist(int id) = 0;
  virtual QList<TRACK> *queryTracksByPhrase(QString phrase, bool byFilename, bool byArtist, bool byTitle, bool byAlbum, bool byComment) = 0;
  
  virtual QList<TRACK> *getLastQuery() = 0;
  
  virtual void disconnect() = 0;
  
  int getError() { return error; }	
  
  virtual ~DataBase() {}
  
 protected:
  int error;
  
 private:
  QMutex mutex;
};

#endif
