# prime/engine/engine-english.rb
# $Id: engine-english.rb,v 1.2 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2005 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

require 'prime/engine/engine-basic'

$engine_class_name = 'PrimeEngineEnglish'

class PrimeEngineEnglish < PrimeEngineBasic
  def initialize
    super('prime-dict-en')

    @name = "English engine"
    @id   = "English"
    @description = "English engine"
  end

  def search (query)
    query.input += query.input.map {|key| key.downcase }
    query.input.uniq!()
    super(query)
  end
end
