/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: presentation.h,v $
 * Revision 1.4  2003/02/25 13:27:55  benj
 * Table of contents is now much more beautiful
 *
 * Revision 1.3  2003/02/18 13:17:31  slash
 * Applied Benjamin's JavaScript patch.
 * Applied some g++-3.2 fixes (mainly missing std::'s).
 *
 * Revision 1.2  2003/02/18 12:56:50  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.1.1.1  2001/01/30 18:36:51  slash
 * Initial release.
 *
 */

#ifndef PRESENTATION_H
#define PRESENTATION_H

#include "node.h"
#include "tocinterface.h"
#include "slidenode.h"

//---------------------------------------------------------------------------
/**
 * This class represents the presentation.
 */
class Presentation : public Node {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor.
     */
    Presentation();

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~Presentation();


    //-----------------------------------------------------------------------
    /**
     * This method starts the parsing of the XML-file, which name is stored
     * in Parameters_.xml_file_.
     *
     * @return 0, if everything is OK, else -1.
     */
    int parseXMLFile();
    

    //-----------------------------------------------------------------------
    /**
     * This method creates HTML-files for the whole presentation to the
     * target directory given by Parameters_->target_directory_.
     * The theme-files and the HTML-files for each slide will be copied
     * into this target directory.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method creates a LaTeX-file for the whole presentation to the
     * target directory given by Parameters_->target_directory_.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes a XML version of the presentation
     */
    void writeXML() const;


    //-----------------------------------------------------------------------
    /**
     * This method sets the title for the presentation
     */
    void setTitle(char * s) { title=s; };

    //-----------------------------------------------------------------------
    /**
     * This method returns the title for the presentation
     */
    char * getTitle() { return title; };
    

  private:

    //-----------------------------------------------------------------------
    /**
     * This helper-method copies all needed theme-files to the
     * target-directory given by Parameters_->target_directory_.
     */
    void copyThemeFiles() const;

    //-----------------------------------------------------------------------
    /**
     * This helper-method creates the table of contents of the presentation.
     */
    void writeTOC() const;

    //-----------------------------------------------------------------------
    /**
     * This helper-method writes misc. files to the presentation directory.
     */
    void writeMisc() const;

  private:

    //-----------------------------------------------------------------------
    /**
     * A pointer to the root of the generated XML-tree of the inputfile.
     */
    xmlDocPtr xml_tree_;

    //-----------------------------------------------------------------------
    /**
     * This vector holds pointers to all slides and sections in the
     * presentation.
     * This vector will be used to create the table of contents.
     */
    std::vector<TOCInterface*> toc_nodes_;

    char *title;

};

#endif //PRESENTATION_H
