dnl This macro will add the given preprocessor-flag to the variable CPPFLAGS.
dnl If the preprocessor-flag already exists, nothing happens.
dnl   $1 - The new preprocessor-flag : For example : -I/usr/local/include
AC_DEFUN(AC_MY_ADD_CPPFLAGS,[
	ac_add_flag=1

	for ac_cppflag in $CPPFLAGS
	do
		if test "$ac_cppflag" = "$1"
		then
			ac_add_flag=0
		fi
	done

	if test $ac_add_flag = 1
	then
		CPPFLAGS="$CPPFLAGS $1"
	fi
])


dnl This macro will add the given library-flag to the variable LIBS.
dnl If the library-flag already exists, nothing happens.
dnl   $1 - The new library-flag. For example : -L/usr/local/lib
AC_DEFUN(AC_MY_ADD_LIBS,[
	ac_add_flag=1

	for ac_lib in $LIBS
	do
		if test "$ac_lib" = "$1"
		then
			ac_add_flag=0
		fi
	done

	if test $ac_add_flag = 1
	then
		LIBS="$LIBS $1"
	fi
])
