#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <config.h>
#include <support.h>

#include "option.h"
#include "frame.h"
#include "timer.h"
#include "env.h"

#define	LQR_RECS	11
#define	LQR_PKTSIZ	(sizeof(u_int32_t)*LQR_RECS)

struct lqr_s {
    u_int32_t
	lastOutLQRs,
	lastOutPackets,
	lastOutOctets,
	peerInLQRs,
	peerInPackets,
	peerInDiscards,
	peerInErrors,
	peerInOctets,
	peerOutLQRs,
	peerOutPackets,
	peerOutOctets;
    u_int32_t
	saveInLQRs,
	saveInPackets,
	saveInDiscards,
	saveInErrors,
	saveInOctets;
};

static struct lqr_s lLqr, rLqr;
static struct timer_s lqmTimer;

static struct lqmopt_s {
    u_int32_t itv;
    u_int32_t count;
} lqmOpt;

static struct lqmstat_s {
    u_int32_t error;
} lqmStat;

static void
LqrEnable(bool_t sw)
{
    FrameEnable(NBO_PROTO_LQR, sw);
    pppOpt.nbo_qual_type = sw ? NBO_PROTO_LQR: 0;
}

static void
LqmTimerHandler()
{
    if (!lqmOpt.itv) lqmTimer.st_expired = 1;
    lqmTimer.rest = lqmOpt.itv;
}

void
LqrSetup()
{
    static struct env_s envlist[]={
	{"INTERVAL", {&lqmOpt.itv}, ENV_INT32, 0, 0, 0666},
	{"COUNT", {&lqmOpt.count}, ENV_INT32, 0, 0, 0666},
	{NULL}
    };
    RegisterEnvs(envlist, "LQM", LqrEnable);
    lqmTimer.name = "LQM";
    lqmTimer.callback = LqmTimerHandler;
    lqmTimer.f_interval = 1;		/* interval */
}

time_t
LqrDecodeFrame(u_char *buf, int len, long arg)
{
    unsigned n;
    struct lqr_s lqr;
    u_int32_t *ls, *ld, nbo_magic;

    memset(&lqr, 0, sizeof(lqr));
    ls = (u_int32_t *)buf;
    ld = (u_int32_t *)&lqr;
    nbo_magic = *ls ++;
    for (n = 0; n < LQR_RECS; n ++, ld ++, ls ++) *ld = ntohl(*ls);
/*
printf("%x:", ntohl(nbo_magic));
    ld = (u_int32_t *)&lqr;
    for (n = 0; n < LQR_RECS; n ++, ld ++, ls ++) printf(" %d", *ld);
printf("\n");
*/
    return(0);	/* do not count */
}

void
LqrStart()
{
    memset(&lLqr, 0, sizeof(struct lqr_s));
    memset(&rLqr, 0, sizeof(struct lqr_s));
    if (lqmOpt.itv) {
	lqmTimer.rest = lqmOpt.itv;
	TimerAdd(&lqmTimer);
    }
}
