#!/bin/bash

SUMMARY_FILE="refa1.tex"
TEXT_FILES="*.tex"

ls $TEXT_FILES | \
  grep -v $SUMMARY_FILE | \
  xargs cat | \
  perl -n -e 'while (/\\pllcommand\{(.+?)[\(\}]/g) { print "$1\n"; };' | \
  sort | \
  uniq > described_in_text.list

cat $SUMMARY_FILE | \
  perl -n -e 'while (/\\pllcommand\{(.+?)[\(\}]/g) { print "$1\n"; };' | \
  sort | \
  uniq > described_in_summary.list


echo "Text    Summary Both"
echo "--------------------"

comm described_in_text.list described_in_summary.list

rm described_in_text.list
rm described_in_summary.list
