/*
 * PIMPPA - adddir
 *
 * Adds files on the current dir to the filearea '0'
 *
 */

#include "pimppa.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <limits.h>
#include <ctype.h>

int Verbose=0;

int adddir(void)
{
	MYSQL *db;
	int added_files=0;
	DIR *dirri;
	struct dirent *dirdata;
	struct stat st;
	char *value;
	int to_lowercase;

	db=p_connect();
	if(!db)
		return(0);
	
	value=p_getmisc(db, P_KEY_TOLOWERCASE);
	if(value)
		to_lowercase=atoi(value);
	else
		to_lowercase=atoi(P_TOLOWERCASE);

	dirri=opendir(".");
	if(!dirri)
	{	
		fprintf(stderr, "Unable to open current dir.\n");
		return(-1);
	}

	while((dirdata=readdir(dirri)))
	{
		char escaped_fn[2*P_LEN_FILE_NAME+1];
		int i=0;
	
		if(stat(dirdata->d_name, &st)!=0)
		{
			fprintf(stderr, "stat() error on %s\n", 
					dirdata->d_name);
			continue;
		}
			
		if(!(S_ISREG(st.st_mode) || S_ISLNK(st.st_mode))
			|| S_ISDIR(st.st_mode))
			continue;

		if(to_lowercase)
		{
			while(dirdata->d_name[i])
			{
				dirdata->d_name[i]=tolower(dirdata->d_name[i]);
				i++;
			}
		}

		mysql_escape_string(escaped_fn, dirdata->d_name, 
							strlen(dirdata->d_name));

	        p_query(db, "REPLACE INTO p_files "
         	            "  (file_name, file_area, file_size, file_date) "
                    	    "VALUES ('%s',%d,%ld,FROM_UNIXTIME(%ld))",
	                escaped_fn, 0, st.st_size,
        	        st.st_mtime);
		if(mysql_error(db)[0])
		{
			fprintf(stderr, "%s\n", mysql_error(db));
			break;
		}
		added_files++;
	}
	closedir(dirri);
		
	mysql_close(db);
	return(added_files);
}
	

int main(int argc, char *argv[])
{
	int added_files;
	int go=1;

	while(go)
	{
		switch(getopt(argc, argv, "avVh"))
		{
			case 'v':
				Verbose=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
				printf("Usage: %s <options>\n\n", argv[0]);
				printf("-v     Verbose execution\n");
				return(0);
				break;
			default:
				go=0;
				break;
		}
	}	

	added_files=adddir();

	fprintf(stderr, "Done, %d files added.\n", added_files);
		
	return(0);
}

