//
// C++ Implementation: runcommandinxterm
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include <algorithm>
#include <functional>

#include <qstring.h>
#include <qprocess.h>

#include "runcommandinxterm.h"

namespace NApplication {



RunCommandInXterm::RunCommandInXterm()
{
	_pProcess=0;
}


RunCommandInXterm::~RunCommandInXterm()
{
	delete _pProcess;
}


void RunCommandInXterm::addArgument(const QString& arg)
{
	_arguments.push_back(arg);
}


bool RunCommandInXterm::start()
{
	QProcess* _pProcess = new QProcess(0, "XTermProcess");
	_pProcess->addArgument("xterm");
	_pProcess->addArgument("-e (");
//	for_each(_arguments.begin(), _arguments.end(), 
//		bind1st(
//			mem_fun(  /*(void (QProcess::*)(const QString&))*/ &QProcess::addArgument  ),
//		_pProcess)
//	 );
	// finally given up trying to find an STL way :-(
	NExtStd::for_each(_arguments.begin(), _arguments.end(), &QProcess::addArgument, _pProcess);
	_pProcess->addArgument("&&");
	_pProcess->addArgument("echo");
	_pProcess->addArgument("\"Execution completed successfully! XTerm will close in 10 seconds.\"");
	_pProcess->addArgument("&&");
	_pProcess->addArgument("sleep 10");
	_pProcess->addArgument("|| sleep 10)");
	/// (echo \"Execution failed. XTerm will close in 10 seconds.\" && 
	// forward the signal
	connect(_pProcess, SIGNAL(processExited()), this, SLOT(onProcessExited()));
	_pProcess->start();
	return true;
}

void RunCommandInXterm::onProcessExited()
{
	delete _pProcess;
	_pProcess = 0;
	emit processExited();
	emit quit();
}

};
