//
// C++ Interface: cacheaccess
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef __CACHE_ACCESS_H_2004_09_17
#define __CACHE_ACCESS_H_2004_09_17

#include <apt-pkg/pkgcachegen.h>
#include <apt-pkg/init.h>
#include <apt-pkg/progress.h>
#include <apt-pkg/sourcelist.h>

/** @brief The main task of this class is to encapsulate the creation of the 
  * contained data structures. 
  *
  * The elements may be used to perform apt-cache search or show like operations.
  */
class CacheAccess
{
	/** The mmap to be used. */
	MMap* _pMap;
	/** The cache used. */
	pkgCache* _pCache;
	/** Do not really know... */
	pkgSourceList* _pSrcList;
public:
	/** Fills the pointers with live. After construction you can use this structure. */
	CacheAccess();
	~CacheAccess();
	/** @returns the #_pMap property. */
	MMap* pMap() const	{ return _pMap; }
	/** @returns the #_pCache property. */
	pkgCache* pCache() const	{ return _pCache; }
	/** @returns the #_pSrcList property. */
	pkgSourceList* pSrcList() const	{ return _pSrcList; }
	/** Sets the #_pMap property. */
	void setPMap(MMap* pMap)	{ _pMap=pMap; }
	/** Sets the #_pCache property. */
	void setPCache(pkgCache* pCache)	{ _pCache=pCache; }
	/** Sets the #_pSrcList property. */
	void setPSrcList(pkgSourceList* pSrcList)	{ _pSrcList=pSrcList; }
};

#endif	// __CACHE_ACCESS_H_2004_09_17
