/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class PerfEntry
implements Externalizable {
    long received;
    long done;
    long total;

    public long getReceived() {
        return this.received;
    }

    public long getDone() {
        return this.done;
    }

    public long getTotal() {
        return this.total;
    }

    public void setReceived(long r) {
        this.received = r;
    }

    public void setDone(long d) {
        this.done = d;
        if (this.received > 0L && this.done > 0L && this.done >= this.received) {
            this.total = this.done - this.received;
        }
    }

    public String toString() {
        if (this.total >= 0L) {
            return "time: " + this.total;
        }
        return "time: n/a";
    }

    public String printContents(boolean detailed) {
        StringBuffer sb = new StringBuffer();
        if (detailed) {
            if (this.received > 0L) {
                sb.append("received=" + this.received);
            }
            if (this.done > 0L) {
                if (this.received > 0L) {
                    sb.append(", ");
                }
                sb.append("done=" + this.done);
            }
        }
        if (detailed && (this.received > 0L || this.done > 0L)) {
            sb.append(", ");
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.received);
        out.writeLong(this.done);
        out.writeLong(this.total);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.received = in.readLong();
        this.done = in.readLong();
        this.total = in.readLong();
    }

    private final /* synthetic */ void this() {
        this.received = 0L;
        this.done = 0L;
        this.total = -1;
    }

    public PerfEntry() {
        this.this();
    }
}

