/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Header;
import org.javagroups.ViewId;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NakAckHeader
extends Header {
    public static final int NAK_MSG = 1;
    public static final int NAK_ACK_MSG = 2;
    public static final int WRAPPED_MSG = 3;
    public static final int RETRANSMIT_MSG = 4;
    public static final int NAK_ACK_RSP = 5;
    public static final int OUT_OF_BAND_MSG = 6;
    public static final int OUT_OF_BAND_RSP = 7;
    int type;
    long seqno;
    long last_seqno;
    ViewId vid;
    Vector stable_msgs;
    Address sender;

    public long size() {
        return 512L;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.seqno);
        out.writeLong(this.last_seqno);
        out.writeObject(this.vid);
        out.writeObject(this.stable_msgs);
        out.writeObject(this.sender);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.seqno = in.readLong();
        this.last_seqno = in.readLong();
        this.vid = (ViewId)in.readObject();
        this.stable_msgs = (Vector)in.readObject();
        this.sender = (Address)in.readObject();
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader(this.type, this.seqno, this.vid);
        ret.last_seqno = this.last_seqno;
        ret.stable_msgs = this.stable_msgs != null ? (Vector)this.stable_msgs.clone() : null;
        ret.sender = this.sender;
        return ret;
    }

    public static String type2Str(int t) {
        switch (t) {
            case 1: {
                return "NAK_MSG";
            }
            case 2: {
                return "NAK_ACK_MSG";
            }
            case 3: {
                return "WRAPPED_MSG";
            }
            case 4: {
                return "RETRANSMIT_MSG";
            }
            case 5: {
                return "NAK_ACK_RSP";
            }
            case 6: {
                return "OUT_OF_BAND_MSG";
            }
            case 7: {
                return "OUT_OF_BAND_RSP";
            }
        }
        return "<undefined>";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[NAKACK: " + NakAckHeader.type2Str(this.type) + ", seqno=" + this.seqno + ", last_seqno=" + this.last_seqno + ", vid=" + this.vid);
        if (this.type == 3) {
            ret.append(", sender=" + this.sender);
        }
        ret.append("]");
        return ret.toString();
    }

    private final /* synthetic */ void this() {
        this.type = 0;
        this.seqno = -1;
        this.last_seqno = -1;
        this.vid = null;
        this.stable_msgs = null;
        this.sender = null;
    }

    public NakAckHeader() {
        this.this();
    }

    public NakAckHeader(int type, long seqno, ViewId vid) {
        this.this();
        this.type = type;
        this.seqno = seqno;
        this.vid = vid;
    }
}

