/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.service;

import java.util.LinkedList;
import org.javagroups.Address;
import org.javagroups.Channel;
import org.javagroups.MembershipListener;
import org.javagroups.MessageListener;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.log.Trace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractService
implements MembershipListener {
    protected Channel serviceChannel;
    protected PullPushAdapter serviceAdapter;
    protected Channel clientChannel;
    protected LinkedList members;
    protected boolean blocked;
    protected Object blockMonitor;
    protected Object threadMonitor;
    protected boolean runThread;

    public abstract String getName();

    protected void setMessageListener(MessageListener listener) {
        this.serviceAdapter.setListener(listener);
    }

    public Address getAddress() {
        return this.serviceChannel.getLocalAddress();
    }

    public boolean isCoordinator() {
        return this.getAddress().equals(this.members.getFirst());
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitOnBlocked() throws InterruptedException {
        Object object = this.blockMonitor;
        synchronized (object) {
            this.blockMonitor.wait();
            return;
        }
    }

    public void block() {
        this.blocked = true;
    }

    public void suspect(Address suspectedMember) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void viewAccepted(View view) {
        Object object = this.members;
        synchronized (object) {
            this.members.clear();
            this.members.addAll(view.getMembers());
        }
        object = this.blockMonitor;
        synchronized (object) {
            this.blocked = false;
            this.blockMonitor.notifyAll();
            return;
        }
    }

    public void start() {
        this.runThread = true;
        Runnable runnable = new Runnable(this){
            final /* synthetic */ AbstractService this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public final void run() {
                while (this.this$0.runThread) {
                    Object object = this.this$0.threadMonitor;
                    // MONITORENTER : object
                    {
                        try {
                            this.this$0.threadMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            {
                this.this$0 = abstractService;
            }
        };
        Thread thread = new Thread(runnable, this.getName() + " Thread [" + this.getAddress() + ']');
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (!this.runThread) {
            return;
        }
        this.runThread = false;
        Object object = this.threadMonitor;
        synchronized (object) {
            this.threadMonitor.notifyAll();
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.members = new LinkedList();
        this.blockMonitor = new Object();
        this.threadMonitor = new Object();
    }

    public AbstractService(Channel serviceChannel, Channel clientChannel) {
        this.this();
        this.serviceChannel = serviceChannel;
        this.serviceAdapter = new PullPushAdapter((Transport)serviceChannel, this);
        this.clientChannel = clientChannel;
        try {
            serviceChannel.getState(null, 1000L);
        }
        catch (Exception ex) {
            Trace.error("AbstractService.AbstractService()", "exception fetching state: " + ex);
        }
    }
}

