/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;
import org.javagroups.Event;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AUTOCONF
extends Protocol {
    HashMap config;
    int num_iterations;

    public String getName() {
        return "AUTOCONF";
    }

    public void init() throws Exception {
        this.senseNetworkConfiguration();
        if (Trace.trace) {
            Trace.info("AUTOCONF.init()", "configuration is\n" + this.config);
        }
    }

    public void start() throws Exception {
        if (this.config != null && this.config.size() > 0) {
            Event config_evt = new Event(56, this.config);
            this.passDown(config_evt);
            this.passUp(config_evt);
        }
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("num_iterations");
        if (str != null) {
            this.num_iterations = new Integer(str);
            props.remove("num_iterations");
        }
        if (props.size() > 0) {
            System.err.println("AUTOCONF.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    void senseNetworkConfiguration() {
        this.senseMaxSendBufferSize(this.config);
        this.senseMaxReceiveBufferSize(this.config);
        this.senseMaxFragSize(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void senseMaxSendBufferSize(HashMap map) {
        DatagramSocket sock = null;
        int max_size = 4096;
        int retval = 32000;
        try {
            try {
                sock = new DatagramSocket();
                while (true) {
                    sock.setSendBufferSize(max_size);
                    retval = sock.getSendBufferSize();
                    if (retval < max_size) {
                        Object var6_5 = null;
                        map.put("send_buf_size", new Integer(retval));
                        return;
                    }
                    max_size *= 2;
                }
            }
            catch (Throwable ex) {
                retval = 32000;
                Trace.error("AUTOCONF.senseMaxSendBufferSize()", "failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
                Object var6_6 = null;
                map.put("send_buf_size", new Integer(retval));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            map.put("send_buf_size", new Integer(retval));
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void senseMaxReceiveBufferSize(HashMap map) {
        DatagramSocket sock = null;
        int max_size = 4096;
        int retval = 32000;
        try {
            try {
                sock = new DatagramSocket();
                while (true) {
                    sock.setReceiveBufferSize(max_size);
                    retval = sock.getReceiveBufferSize();
                    if (retval < max_size) {
                        Object var6_5 = null;
                        map.put("recv_buf_size", new Integer(retval));
                        return;
                    }
                    max_size *= 2;
                }
            }
            catch (Throwable ex) {
                retval = 32000;
                Trace.error("AUTOCONF.senseMaxReceiveBufferSize()", "failed getting the max send buffer size: " + ex + ". Defaulting to " + retval);
                Object var6_6 = null;
                map.put("recv_buf_size", new Integer(retval));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            map.put("recv_buf_size", new Integer(retval));
            throw throwable;
        }
    }

    void senseMaxFragSize(HashMap map) {
        InetAddress local_addr;
        DatagramSocket sock;
        int upper;
        int max_send = 32000;
        int max_recv = 32000;
        int lower = upper = 8192;
        if (this.config.containsKey("send_buf_size")) {
            max_send = (Integer)this.config.get("send_buf_size");
        }
        if (this.config.containsKey("recv_buf_size")) {
            max_recv = (Integer)this.config.get("recv_buf_size");
        }
        try {
            sock = new DatagramSocket();
            local_addr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            Trace.warn("AUTOCONF.senseMaxFragSize()", "failed creating DatagramSocket: " + ex);
            return;
        }
        int i = 0;
        while (i < this.num_iterations) {
            try {
                byte[] buf = new byte[upper];
                DatagramPacket packet = new DatagramPacket(buf, buf.length, local_addr, 9);
                sock.send(packet);
                lower = upper;
                upper *= 2;
            }
            catch (IOException io_ex) {
                upper = (upper + lower) / 2;
            }
            catch (Throwable ex) {
                Trace.warn("AUTOCONF.senseMaxFragSize()", "exception=" + ex);
                break;
            }
            ++i;
        }
        if (lower > max_send) {
            Trace.warn("AUTOCONF.senseMaxFragSize()", "lower (" + lower + ") > max_send (" + max_send + "): using max_send as frag_size");
            lower = max_send;
        }
        map.put("frag_size", new Integer(lower));
        if (Trace.trace) {
            Trace.info("AUTOCONF.senseMaxFragSize()", "frag_size=" + lower);
        }
    }

    private final /* synthetic */ void this() {
        this.config = new HashMap();
        this.num_iterations = 10;
    }

    public AUTOCONF() {
        this.this();
    }
}

