/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

#ifndef INCL_SC
#define INCL_SC

/***********************************************************
* The service-curve data structure 
*
* Note: we consider only two-pice liniar service curves, 
*       defined for any t >= 0 (the first segment starts 
*       in (0, 0))       
************************************************************/ 
#ifdef __cplusplus
extern "C" {
#endif
	
typedef struct {
  unsigned int m1;   /* the slope of the first segment (m1 < 1) */
  unsigned int d;    /* the length of the x-projection of the first segment */
  unsigned int m2;   /* the slope of the second segment (m2 < 1) */
} ServiceCurve;


/***********************************************************
* The run-time service-curve data structure 
*
* Note: we consider only two-pice liniar service curves, 
*       defined for any t >= x (the first segment starts 
*       in (x, y))       
************************************************************/ 

typedef struct {
  unsigned int x;    /* the x-coordinate where the first segment starts (x1 >= 0) */
  unsigned int y;    /* the y-coordinate where the first segment starts (y1 >= 0) */
  unsigned int m1;   /* the slope of the first segment (m1 < 1) */
  unsigned int d;    /* the length of the x-projection of the first segment */
  unsigned int m2;   /* the slope of the second segment (m2 < 1) */
} RTServiceCurve;


/***********************************************************
* The segment data structure 
************************************************************/ 

typedef struct _segment {
  unsigned int x;    /* the x-coordinate where the first segment starts  */
  unsigned int y;    /* the y-coordinate where the first segment starts  */
  unsigned int m;    /* the segment's slope */
  unsigned int d;    /* the length of the segment's x-projection  */
  struct _segment *next;
} Segment;

/***********************************************************
* The general service-curve data structure 
************************************************************/ 

typedef struct { Segment *first;} GenServiceCurve;

	
#ifdef __cplusplus
}
#endif
#endif






