/*
 * tcl-event.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "srmv2-api.h"
#include "srmv2-event.h"
#include <tcl.h>


/* Simple Tcl-based event system. */

/* Register and cancel timer events. */
int  
srm_create_timer_handler(int ms, SRMTimerProc *proc, void *clientData)
{
	return ((int) Tcl_CreateTimerHandler(ms, (Tcl_TimerProc *)proc,
					     (ClientData) clientData));
}


void 
srm_delete_timer_handler(int token)
{
	Tcl_DeleteTimerHandler((Tcl_TimerToken) token);
}


/* Register and cancel file and network events. */
void
srm_create_file_handler(int fd, int mask, SRMFileProc *proc, void *clientData)
{
	Tcl_CreateFileHandler(fd, mask, (Tcl_FileProc *)proc,
			      (ClientData) clientData);
}


void 
srm_delete_file_handler(int fd)
{
	Tcl_DeleteFileHandler(fd);
}
