/*
 * tgmb-canv.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tgmb-canv.h"
#include "tgmb-canvcmd.h"
#include "mb/mb-obj.h"
#include "mb/mb-cmd.h"


DEFINE_OTCL_CLASS(TGMB_Canvas, "TGMB_Canvas")
{
}


class TGMB_CanvItem : public MBCanvItem {
public:
	TGMB_CanvItem(CanvItemId id, TGMB_Canvas *pCanv)
		: MBCanvItem(NULL, NULL, 0), id_(id), pCanv_(pCanv) { }
	virtual ~TGMB_CanvItem() { }
	virtual PageItem* toPageItem();
private:
	CanvItemId id_;
	TGMB_Canvas *pCanv_;
	friend class TGMB_Canvas;
};



TGMB_Canvas::TGMB_Canvas()
	: seqNo_(1), deferUpdate_(FALSE), update_scheduled_(FALSE),
	  got_updates_recently_(FALSE)
{
	// two word key: the first word is the canvas item id
	// and the second word is either 0 (first cmd for this is)
	// or 1 (last cmd for this id)
	Tcl_InitHashTable(&htCanvItems_, 2);

	bind("got_updates_recently_", &got_updates_recently_);
	bind("update_scheduled_", &update_scheduled_);
}


TGMB_Canvas::~TGMB_Canvas()
{
	Tcl_DeleteHashTable(&htCanvItems_);
	while (list_.IsEmpty()==FALSE) {
		delete list_.RemoveFromHead();
	}
}


int
TGMB_Canvas::init(int argc, const char * const *argv)
{
	const char *pageIdStr;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(pageIdStr);
	END_PARSE_ARGS;

	Str2PgId(pageIdStr, pageId_);
	return TCL_OK;
}


Bool
TGMB_Canvas::construct_payload(TclObject *destination,
			       u_char *&data, u_int32_t &len,
			       ListIndex &lastSent)
{
	ListIndex idx;
	u_int32_t startSeqno;
	PageId netPageId;

	data = NULL;
	len  = 0;
	data = new u_char [sizeof(PageId)];
	if (!data) {
		fprintf(stderr, "out of memory");
		abort();
	}
	len = sizeof(PageId);
	host2net(pageId_, netPageId);
	*((PageId*)data) = netPageId;

	if (lastSent==NULL) {
		idx = list_.getFirst();
	} else {
		idx = list_.getNext(lastSent);
	}

	if (idx!=NULL) startSeqno = list_.getData(idx)->seqNo_;

	for ( ; list_.IsDone(idx)==FALSE; idx=list_.getNext(idx)) {
		ApplyEffects(destination, list_.getData(idx),
			     startSeqno, data, len);
	}

	lastSent = list_.getLast();
	if (data!=NULL && len > sizeof(PageId)) {
		fprintf(stderr, "Constructed payload of size %lu\n",
			(unsigned long)len);
		return TRUE;
	}
	else {
		delete [] data;
		data = NULL;
		len  = 0;
		return FALSE;
	}
}


void
TGMB_Canvas::ApplyEffects(TclObject *destination, CanvasCmd *pCmd,
			  u_int32_t startSeqno, u_char *&data, u_int32_t &len)
{
	ChunkFrag frag(destination);
	ChunkFrag::Header hdrNet;
	pCmd->ApplyEffects(&frag, startSeqno);
	if (!frag.is_valid()) return;

	if (!renew(data, len, len + sizeof(frag.hdr_) +frag.hdr_.len_)) {
		fprintf(stderr, "out of memory");
		abort();
	}
	host2net(frag.hdr_, hdrNet);

	memcpy(data+len, &hdrNet, sizeof(hdrNet));
	memcpy(data+len+sizeof(hdrNet), frag.data_, frag.hdr_.len_);
	len += sizeof(hdrNet) + frag.hdr_.len_;
}


Bool
TGMB_Canvas::construct_image_payload(TclObject *destination, u_int32_t canvId,
				     u_char *&data, u_int32_t &len)
{
	CanvasCreateCmd *pCanvCmd = FindFirstCmd(canvId);
	PageId netPageId;

	data = NULL;
	len  = 0;

	// check if this is a valid image command
	if (!pCanvCmd || !pCanvCmd->pCmd_ || !pCanvCmd->pCmd_->getItem() ||
		pCanvCmd->pCmd_->getItem()->getType()!=PgItemImage)
		return FALSE;

	// apply the effects of all operations on this item

	data = new u_char [sizeof(PageId)];
	if (!data) {
		fprintf(stderr, "out of memory");
		abort();
	}
	len = sizeof(PageId);
	host2net(pageId_, netPageId);
	*((PageId*)data) = netPageId;

	ApplyEffects(destination, pCanvCmd, 0, data, len);
	if (data!=NULL && len > sizeof(PageId)) {
		return TRUE;
	}
	else {
		delete [] data;
		data = NULL;
		len  = 0;
		return FALSE;
	}
}


#if 0
int
TGMB_Canvas::do___(int argc, const char * const *argv)
{
	const char *canv;
	u_int32_t seqno;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(canv);
	ARG(seqno);
	END_PARSE_ARGS;

	ListIndex idx;
	CanvasCmd *cmd;
	for (idx=list_.getLast(); list_.IsDone(idx)==FALSE;
	     idx=list_.getPrev(idx)) {
		cmd = list_.getData(idx);
		if (cmd->seqNo_==seqno) {
			do_real___(canv, idx);
			return TCL_OK;
		}
	}

	return TCL_OK;
}


void
TGMB_Canvas::do_real___(const char *canv, ListIndex idx)
{
	CanvasCmd *cmd;
	u_int32_t seqno = list_.getData(idx)->seqNo_;
	ChunkFrag data(NULL);
	char buffer[32767];
	u_int16_t cmdDescr, len, numCoords, *coords;
	u_int32_t id;
	void *dummy;
	int i;

	for ( ; list_.IsDone(idx)==FALSE; idx=list_.getNext(idx)) {
		sprintf(buffer, "%s ", canv);
		data.flush();
		cmd = list_.getData(idx);
		cmd->ApplyEffects(&data, seqno);
		if (!data.is_valid()) continue;
		cmdDescr = data.hdr_.cmd_;
		id = data.hdr_.canvCmdId_;
		data.get_any(descrCoords, dummy, len);
		coords = new u_int16_t [numCoords = len/2];
		for (i=0; i<len/2; i++) {
			memcpy(coords+i, dummy+(i*2), 2);
			coords[i] = ntohs(coords[i]);
		}

		switch (cmdDescr) {
		case cmdCanvasCreate:
		{
			u_int16_t itemType, value;
			void *str;
			static char *list[] = {
				"nothing",
				"line",
				"rectangle",
				"oval",
				"foobar",
				"text",
				"nothing",
				"nothing",
				"nothing"
			};

			data.get(descrItemType, itemType);
			sprintf(&buffer[strlen(buffer)],
				"create %s ", list[itemType]);
			for (i=0; i<numCoords; i++) {
				sprintf(&buffer[strlen(buffer)],
					"%d ", coords[i]);
			}

			sprintf(&buffer[strlen(buffer)],
				"-tags id%d ", id);
			if (data.get(descrColor, value)==TRUE) {
				value = (value >> 8) & 0xFF;
				sprintf(&buffer[strlen(buffer)],
					"-outline #%02x%02x%02x ",
					value, value, value);
			}
			if (data.get(descrFill, value)==TRUE) {
				value = (value >> 8) & 0xFF;
				sprintf(&buffer[strlen(buffer)],
					"-fill #%02x%02x%02x ",
					value, value, value);
			}
			if (data.get(descrWidth, value)==TRUE) {
				sprintf(&buffer[strlen(buffer)],
					"-width %d ", value);
			}
			/*if (data.get_any(descrFont, str, len)==TRUE) {
				sprintf(&buffer[strlen(buffer)],
					"-font %s ", (char*)str);
			}*/
			if (data.get_any(descrText, str, len)==TRUE) {
				sprintf(&buffer[strlen(buffer)],
					"-text {%s} ", (char*)str);
			}


			break;
		}
		case cmdCanvasMove:
			sprintf(&buffer[strlen(buffer)],
				" move id%d %d %d", id,
				(int16_t)coords[0],
				(int16_t)coords[1]);
			break;

		case cmdCanvasDelete:
			sprintf(&buffer[strlen(buffer)],
				" delete id%d", id);
			break;

		case cmdCanvasConfigText:
		{
			void *text, *font;
			u_int16_t color;
			data.get_any(descrText, text, len);
			//data.get_any(descrFont, font, len);
			data.get(descrColor, color);
			sprintf(&buffer[strlen(buffer)],
				" itemconfigure id%d -text %s "
				"-fill #%02x%02x%02x",
				id, (char*)text, /*(char*)font,*/
				color, color, color);
			break;
		}
		}
		delete [] coords;
		fprintf(stderr, "%s\n", buffer);
		Tcl::instance().eval(buffer);
	}
}
#endif


CanvItemId
TGMB_Canvas::addCanvCmd(CanvasCmd *pCanvCmd) //, Bool firstOne)
{
	if (list_.InsertAtTail(pCanvCmd)==FALSE) return 0;

	// try to locate the last command associated with this id in the
	// hash table
	int isNewEntry;
	int key[2] = { pCanvCmd->id_, 1 };
	Tcl_HashEntry *pEntry = Tcl_CreateHashEntry(&htCanvItems_, (char*)key,
						    &isNewEntry);

	if (!isNewEntry) {
		// there alreay was an entry in the hash table
		// link that command to this one
		CanvasCmd *pOldCmd;
		pOldCmd = (CanvasCmd*)Tcl_GetHashValue(pEntry);
		assert(pCanvCmd->id_==pCanvCmd->id_);
		pOldCmd ->next_link_ = pCanvCmd;
		pCanvCmd->prev_link_ = pOldCmd;
	}

	Tcl_SetHashValue(pEntry, (ClientData) pCanvCmd);

	if (isNewEntry) {
		// we must add another entry to the hash table
		// to identify the very first cmd associated with this id
		assert(pCanvCmd->getType()==cmdCanvasCreate);

		key[1] = 0;
		pEntry = Tcl_CreateHashEntry(&htCanvItems_, (char*)key,
					     &isNewEntry);
		if (!isNewEntry) {
			disperr("Item id %d already exists in the "
				"canvas\n", pCanvCmd->id_);
			assert(FALSE && "duplicate item id");
			return 0;
		}
		Tcl_SetHashValue(pEntry, (ClientData) pCanvCmd);
	}


	if (DeferUpdateNotification()==FALSE) {
		UpdateClients();
		//Invokef("update %lu %lu", pCanvCmd->id_, pCanvCmd->seqNo_);
	}
	seqNo_++;

	return pCanvCmd->id_;
}


CanvItemId
TGMB_Canvas::createItem(Page* /*pPage*/, MBCmd* pCmd,
			PageItem* /*pPgItem*/)
{
	CanvasCreateCmd *pCanvCmd = new CanvasCreateCmd(seqNo_, seqNo_, pCmd);
	return addCanvCmd(pCanvCmd);
}


Bool
TGMB_Canvas::deleteItem(const CanvItemId canvId, MBCmd* pCmd)
{
	CanvasDeleteCmd *pCanvCmd = new CanvasDeleteCmd(canvId, seqNo_, pCmd);
	if (addCanvCmd(pCanvCmd)==0) return FALSE;
	else return TRUE;
}


Bool
TGMB_Canvas::moveItem(CanvItemId targetId, MBCmd* pCmd,
		      Coord /*dx*/, Coord /*dy*/)
{
	CanvasMoveCmd *pCanvCmd = new CanvasMoveCmd(targetId, seqNo_, pCmd);
	if (addCanvCmd(pCanvCmd)==0) return FALSE;
	else return TRUE;
}


void
TGMB_Canvas::raiseAfter(CanvItemId b4Id, CanvItemId afId)
{
	CanvasRaiseCmd *pCanvCmd = new CanvasRaiseCmd(afId, seqNo_, NULL,
						      b4Id);
	if (addCanvCmd(pCanvCmd)==0) return;
}


void
TGMB_Canvas::setText(CanvItemId cid, MBCmd* pCmd, const char* szText)
{
	fprintf(stderr, "setText got '%s'\n", szText);
	CanvasConfigTextCmd *pCanvCmd = new CanvasConfigTextCmd(cid, seqNo_,
								pCmd, szText);
	if (addCanvCmd(pCanvCmd)==0) return;
}


char *
TGMB_Canvas::getText(CanvItemId cid, int& len)
{
	const char *text = NULL;
	CanvasCmd *pCanvCmd;

	for (pCanvCmd =  FindLastCmd(cid);
	     pCanvCmd != NULL;
	     pCanvCmd =  pCanvCmd->prev_link_) {
		if (pCanvCmd->getType()==cmdCanvasConfigText) {
			text = ((CanvasConfigTextCmd*)pCanvCmd)->getText();
			break;
		}
		else if (pCanvCmd->getType()==cmdCanvasCreate) {
			if (pCanvCmd->pCmd_) {
				const PageItem *pItem;
				pItem = pCanvCmd->pCmd_->getItem();
				if (pItem && pItem->getType()==PgItemText) {
					text = ((TextItem*)pItem)->szText_;
					break;
				}
			}
		}
	}

	if (!text) text = "";
	int slen = strlen(text) + 1;
	if (slen > len) len = slen;
	char *szNew = new char[len];
	strcpy(szNew, text);
	fprintf(stderr, "getText returning '%s'\n", szNew);
	return szNew;
}


CanvItemId
TGMB_Canvas::createImage(Page* pPage, MBCmd* pCmd, ImageItem* pItem,
			 const char* szFileName)
{
	if (!pItem->getImageName()) {
		pItem->setImageName(szFileName);
	}

	CanvItemId id = createItem(pPage, pCmd, pItem);
	// !!! add this:id -> szFileName to a global hashtable
	return id;
}


MBCanvItem*
TGMB_Canvas::getItem(const CanvItemId canvId)
{
	TGMB_CanvItem *pCanvItem = new TGMB_CanvItem(canvId, this);
	return pCanvItem;
}


CanvItemId
TGMB_Canvas::createItem(Page* /*pPage*/, MBCmd* pCmd, MBCanvItem* pItem)
{
	TGMB_CanvItem *pCanvItem = (TGMB_CanvItem*)pItem;
	CanvasUndeleteCmd *pCanvCmd = new CanvasUndeleteCmd(pCanvItem->id_,
							    seqNo_, pCmd);
	return addCanvCmd(pCanvCmd);
}


Bool
TGMB_Canvas::toChunkFrag(ChunkFrag *frag, CanvItemId id)
{
	CanvasCmd *pCanvCmd = FindLastCmd(id);
	if (!pCanvCmd) return FALSE;

	// go back to the first command associated with this id
	while (pCanvCmd->prev_link_!=NULL)
		pCanvCmd = pCanvCmd->prev_link_;

	// construct the ChunkFrag structure
	pCanvCmd->ApplyEffects(frag, 0);
	return TRUE;
}


// converts to a page item
PageItem*
TGMB_CanvItem::toPageItem()
{
	ChunkFrag frag(NULL);
	if (pCanv_->toChunkFrag(&frag, id_)==FALSE) return NULL;

	// extract the descrItemType field
	u_int16_t itemType = PgItemInvalid, len;
	void *value;
	if (frag.get(descrItemType, itemType)==FALSE) {
		SignalError(("Could not determine item type!"));
		return NULL;
	}

	// create the PageItem object
	PageItem* pItem = PageItem::createItem((PageItemType)itemType);
	if (!pItem) {
		SignalError(("Out of memory!"));
		return NULL;
	}

	// extract the descrCoords field
	if (frag.get_any(descrCoords, value, len)==FALSE) {
		SignalError(("Could not find item coordinates!"));
		return NULL;
	}

	assert( (len % 4) == 0 && "len should be a multiple of 4");

	int numPoints = len/4;
	Point* points = new Point[numPoints];
	u_int16_t tmp;
	for (int i=0; i<numPoints; i++) {
		memcpy(&tmp, value, 2);
		points[i].x = (u_int16_t) ntohs(tmp);
		value = ((u_char*)value) + 2;

		memcpy(&tmp, value, 2);
		points[i].y = (u_int16_t) ntohs(tmp);
		value = ((u_char*)value) + 2;
	}

	pItem->setPoints(points, numPoints);
	frag.get_props(pItem);

	if (itemType==PgItemImage) {
		// this is an image
		// retrieve the filename from the original command and put
		// it into the PageItem
		CanvasCmd *pCanvCmd = pCanv_->FindFirstCmd(id_);
		assert(pCanvCmd);

		MBCmd *pCmd = pCanvCmd->getMBCmd();
		if (!pCmd || pCmd->getType()!=CGroup ||
		    ((MBCmdGroup*)pCmd)->getGroupType()!=PgItemImage) {
			assert (FALSE && "this cmd should be an MBCmdImage");
		}

		const char *filename = ((MBCmdImage*)pCmd)->getFileName();
		((ImageItem*)pItem)->setImageName(filename);
	}

	// !!! if itemType is image, then get the filename
	// corresponding to pCanv_:id_ and store it in PageItem
	return pItem;
}

