# rrecorder.tcl --
#
#       Test app for testing RecorderClient and Recorder RPC API
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RecorderClient

Class RecorderClientApp

RecorderClientApp instproc init {hostname port} {
    $self instvar rc_

    set rc_ [new RecorderClient $hostname $port]

    $self initUI ""
}

RecorderClientApp instproc initUI {base} {
    $self instvar recButton_ stopButton_

    wm title . "Recorder Client"
    wm minsize . 150 0

    set recButton_ [button .record -text "Record" -command "$self record"]
    pack .record -side top
    set stopButton_ [button .cancel -text "Stop" -command "$self stop" -state disabled]
    pack .cancel -side top

    button .exit -text "Exit" -command "exit"
    pack .exit -side bottom
}

RecorderClientApp instproc record {} {
    $self instvar rc_ recButton_ stopButton_

    $rc_ record
    $recButton_ configure -state disabled
    $stopButton_ configure -state normal
}

RecorderClientApp instproc stop {} {
    $self instvar rc_ recButton_ stopButton_

    $rc_ stop
    $recButton_ configure -state disabled
    $stopButton_ configure -state disabled
}


# main program

set hostname "media0.bmrc.berkeley.edu"
set port 6909
set dcc [new RecorderClientApp $hostname $port]



vwait forever
