#!/bin/sh
# path trick for tclsh variants \
exec tclsh $0 ${1+"$@"}

# simVmark.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_files g_levels g_range

proc showUsage {} {
    puts -nonewline stdout "usage: "
    puts stdout "simVmark.tcl -m <mark file> -s <sim file> \[-l <speaker> <left> <center> <right>\] \[-r <begin> <end>\]"
    exit
}

proc getFlags {argv} {
    global g_files g_levels g_range

    set g_files(mark) ""
    set g_files(sim) ""
    set g_levels(speaker) 10
    set g_levels(left) 100
    set g_levels(center) 125
    set g_levels(right) 150
    set g_range(begin) all
    set g_range(end) all

    set state flag
    foreach arg $argv {
        switch -exact -- $state {
            flag {
                switch -exact -- $arg {
                    -s {
                        set state simFile
                    }
		    -m {
                        set state markFile
                    }
		    -l {
                        set state levels
                    }
		    -r {
                        set state range
                    }
                    default {
                        showUsage
                        exit
                    }
                }
            }
	    simFile {
		set g_files(sim) $arg
		set state flag
	    }
	    markFile {
		set g_files(mark) $arg
		set state flag
	    }
	    levels {
		set g_levels(speaker) $arg
		set state left
	    }
	    left {
		set g_levels(left) $arg
		set state center
	    }
	    center {
		set g_levels(center) $arg
		set state right
	    }
	    right {
		set g_levels(right) $arg
		set state flag
	    }
	    range {
		set g_range(begin) $arg
		set state end
	    }
	    end {
		set g_range(end) $arg
		set state flag
	    }
	}
    }

    if {$g_files(mark) == "" || $g_files(sim) == ""} {
	showUsage
    }

    showParams
}

proc showParams {} {
    global g_files g_levels g_range

    puts stdout "#g_files(mark) = $g_files(mark)"
    puts stdout "#g_files(sim) = $g_files(sim)"
    puts stdout "#g_levels(speaker) = $g_levels(speaker)"
    puts stdout "#g_levels(left) = $g_levels(left)"
    puts stdout "#g_levels(center) = $g_levels(center)"
    puts stdout "#g_levels(right) = $g_levels(right)"
    puts stdout "#g_end(begin) = $g_range(begin)"
    puts stdout "#g_end(end) = $g_range(end)"
}

proc init {argv} {
    global g_files g_levels g_range

    if {[llength $argv] == 0} {
	showUsage
    }

    getFlags $argv
}

proc build {} {
    global g_files g_levels g_range

    set ls $g_levels(speaker)
    set ll $g_levels(left)
    set lc $g_levels(center)
    set lr $g_levels(right)
    set b $g_range(begin)
    set e $g_range(end)

    exec ../utils/mark2graph $g_files(mark) $ls $ll $lc $lr | ../utils/range stdin $b $e > mark.tmp

    set ls [expr $ls + 3]
    set ll [expr $ll + 3]
    set lc [expr $lc + 3]
    set lr [expr $lr + 3]

    exec ../utils/sim2graph $g_files(sim) $ls $ll $lc $lr | ../utils/range stdin $b $e > sim.tmp

    set result [exec assembleGraph.tcl -t "Sim Vs. Mark" -f sim.tmp -l "Sim" -f mark.tmp -l "Mark"]
    puts stdout "$result"

}

# main program

init $argv

build
