# rtsp-worker.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import ArchiveSession/Play/RTP SessionCatalog ArchiveSession/Play/SRM

Class RTSPWorker

RTSPWorker instproc init {mynum from} {
	$self instvar cur_state_ sess_id_ from_

	set cur_state_ init
	set sess_id_ mynum
	set from_ $from


}

RTSPWorker instproc destroy {} {
	$self instvar lts_ sess_id_ session_

	puts "In RTSPWorker destroy"

	$lts_($sess_id_) speed 0.0

	foreach i [array names session_] {
		puts "Session($i): $session_($i)"
		delete $session_($i)
	}

	delete $lts_($sess_id_)


}

RTSPWorker instproc recv {p} {
	$self instvar params_ response_


	if [info exists params_] {
		unset params_
	}


	puts "[llength $p]"
	for {set x 0} {$x < [llength $p]} {incr x 2} {
		set params_([lindex $p $x]) [lindex $p [expr $x + 1]]
	}
	puts "Method: $params_(method)"

	if [catch {$self worker-state-machine} error] {
		set response_(code) 500
		puts "Worker State-machine error"
	}
	puts "Back from worker state machine"

	puts "Worker returning $response_(code)"
	return $response_(code)

}




RTSPWorker instproc worker-state-machine {} {
	$self instvar cur_state_ sess_id_
	$self instvar params_
	$self instvar response_
	$self instvar start_
	$self instvar lts_

	puts "In worker state machine"

	switch $cur_state_ {
		init {
			puts "Cur state init"
			switch $params_(method) {
				SETUP {
					if [catch {$self do_setup} error] {
						set response_(code) 500
						puts "do_setup error"
					} else {
						puts "Back from do_setup $response_(code)"
						if {$response_(code) < 202} {
							set cur_state_ ready
						}
					}
				}
				default {
					set response_(code) 400
					puts "default init"
				}
			}
		}
		ready {
			switch $params_(method) {
				PLAY {
					if [catch {$self do_play} error] {
						set response_(code) 500
					} else {
						if {$response_(code) < 202} {
							set cur_state_ playing
						}
					}

				}
				PAUSE {
					if [catch {$self do_pause} error] {
						set response_(code) 500
					} else {
						if {$response_(code) < 202} {
							set cur_state_ ready
						}
					}
				}
				RECORD {
					set response_(code) 405
					#Method not allowed
				}

				SETUP {
					if [catch {$self do_setup} error] {
						set response_(code) 500
						} else {
						if {$response_(code) < 202} {
							set cur_state_ ready
						}
					}
				}
				default {
					set response_(code) 400
					puts "default ready"
				}
			}
		}
		playing {
			switch $params_(method) {
				PAUSE {
					if [catch {$self do_pause} error] {
						set response_(code) 500
						} else {
						if {$response_(code) < 202} {
							set cur_state_ ready
						}
					}
				}
				PLAY {
					puts "Replay"
					$self do_pause
					puts "paused"
					puts "start: $start_($sess_id_)"
					if [catch {$lts_($sess_id_) now_logical $start_($sess_id_)} error] {
						set $response_(code) 500
						#response: internal server error
						puts "Bad start time"
						#return
					}
					puts "changed time"
					$self do_play
					# ???  Supposed to schedule range
					# after current range
					set cur_state_ playing
				}
				SETUP {
					# ?? Supposed to allow changing
					# params?
					set cur_state_ playing
					puts "got SETUP msg while playing"
				}
				default {
					set response_(code) 400
					puts "default playing"
				}
			}

		}

	}

}

RTSPWorker instproc do_pause {} {
	$self instvar params_ lts_ sess_id_

	if [info exists lts_($sess_id_)] {
		if [catch {$lts_($sess_id_) speed 0.0} error] {
			set response_(code) 500
			} else {
			set response_(code) 200
			}
	} else {
		set response_(code) 451
		puts "No session id param $sess_id_"
		#response:  parameter not understood


	}
}



## In our system, if presentation has been set up, can't then
##individually play or pause streams, because would have to hierarchically
##split lts ??

RTSPWorker instproc do_play {} {
	$self instvar params_ lts_ sess_id_

	puts "In do_play"
	if [info exists lts_($sess_id_)] {
		if [info exists params_(Range)] {
			puts "Here1 $params_(Range)"
			regexp {([a-zA-Z]+)(\=)(.+)} $params_(Range) all rangesspec eqqs rest
			puts $all
			puts "Here2 $rangesspec"
			puts "rest $rest"
			switch $rangesspec {
				npt {
					puts "Here3 $rest"
					regexp {([0-9.]+)(\-)([0-9.]*)} $rest all start mid end
					$lts_($sess_id_) now_logical $start
					puts "Start: $start"


				}
				utc {
					puts "utc not supported yet"
				}
				smpte {
					puts "smpte not supported yet"
				}
				default {
					set response_(code) 451
					puts "Range-specifier not understood"
					# time= clock=???
				}
			}


		}



		$lts_($sess_id_) speed 1.0
		puts "PLAYING object: $lts_($sess_id_)"
		set response_(code) 200

		#response:  ok

	} else {
		set response_(code) 451

		puts "No session id param $sess_id_"
		#response:  parameter not understood
		return 0

		##set new_uri [$self up_one_uri]
		##if exists $server_state_lts($new_uri) {
		##	$server_state_lts_($new_uri) speed 1.0
		##}
	}

}


RTSPWorker instproc setup_stream {filename address port ttl} {
	$self instvar options
	$self instvar params_
	$self instvar lts_
	$self instvar response_
	$self instvar session_ sess_id_
	$self instvar start_

	set indexfile $filename.idx
	#puts $indexfile
	set datafile $filename.dat
	#puts $datafile


	set df [new ArchiveFile/Data]
	if [catch {$df open $datafile} error] {
		set response_(code) 400
		#response: bad request
		puts "Can't open $datafile"
		return 0
	}
	set if [new ArchiveFile/Index]
	if [catch {$if open $indexfile} error] {
		set response_(code) 400
		#response: bad request
		puts "Can't open $indexfile"
		return 0
	}
	if [catch {$df header hdr} error] {
		set response_(code) 500
		#response: internal server error
		puts "Bad header format"
		return 0
	}

	if [info exists session_($address/$port)] {
		set session $session_($address/$port)
	}  else {
		if [catch {set session \
				[new ArchiveSession/Play/$hdr(protocol) \
				$hdr(media) $address/$port/none/$ttl] } error] {
			set response_(code) 500
			#response: internal server error
			# -name problem ?
			puts "Couldn't create session $hdr(protocol) $hdr(media) $address/$port/none/$ttl"
			return 0
		}
		set session_($address/$port) $session
	}

	set stream [$session create_stream]
	$stream datafile $df
	$stream indexfile $if
	$stream lts $lts_($sess_id_)
	puts "Attaching stream to lts: $lts_($sess_id_)"

	$session attach_stream $stream

	if {$hdr(start) != 0} {
        if {$start_($sess_id_) == "max"} {
		puts "In 1"
		set start_($sess_id_) $hdr(start)
		puts "Setting start: $hdr(start)"
		if [catch {$lts_($sess_id_) now_logical $hdr(start)} error] {
			set $response_(code) 500
			#response: internal server error
			puts "Bad start time"
			#return
		}
	} else {
		puts "In 2"
		if {$hdr(start) < $start_($sess_id_)} {
			set start_($sess_id_) $hdr(start)
			puts "Setting start: $hdr(start)"
			if [catch {$lts_($sess_id_) now_logical $hdr(start)} error] {
				set $response_(code) 500
				#response: internal server error
				puts "Bad start time"
				#return
			}
		}

	}
}

	set response_(code) 200

	#response:  OK
	return

}

RTSPWorker instproc setup_ctg {filename sessname address port ttl} {
	$self instvar response_
	$self instvar lts_
	$self instvar params_
	$self instvar session_ sess_id_
	$self instvar start_

	puts "Setup_ctg $filename $sessname"
	set catalog [new SessionCatalog]
	if { [catch {$catalog open $filename} error] } {
		set response_(code) 451
		#response: parameter not understood
		puts "Couldn't open $filename"
		return
	}
	if { [catch {$catalog read} error] } {
		set response_(code) 500
		#response: internal server error
		puts "Couldn't read $filename"
		return
	}
	foreach id [$catalog info streams] {
		lappend sessions([$catalog info session $id]) $id
	}
	set file [new ArchiveFile]
	foreach id $sessions($sessname) {
		puts "hello"
		set my_datafile [$catalog info datafile $id]
		set my_indexfile [$catalog info indexfile $id]
		if [catch {$file open $my_datafile} error] {
			set response_(code) 500
			#response: internal server error
			puts "Couldn't open $my_datafile"
			delete $catalog
			delete $file
			return
		}

		if [catch {$file header data_hdr} error] {
			set response_(code) 500
			#response: internal server error
			puts "Wrong header format for $my_datafile"
			delete $catalog
			delete $file
			return
		}
		$file close
		if [catch {$file open $my_indexfile} error] {
			set response_(code) 500
			#response: internal server error
			puts "Couldn't open $my_indexfile"
			delete $catalog
			delete $file
			return
		}

		if [catch {$file header index_hdr} error] {
			set response_(code) 500
			#response: internal server error
			puts "Wrong header format $my_indexfile"
			delete $catalog
			delete $file
			return
		}

		$file close


		if { $data_hdr(protocol)!=$index_hdr(protocol) } {
			set response_(code) 500
			#response: internal server error
			puts "Protocol fields do not\
					match in data and index files"
			delete $catalog
			delete $file
			return
		}

		if { $data_hdr(media)!=$index_hdr(media) } {
			set response_(code) 500

			#response:  internal server error
			puts "Media fields do not\
					match in $my_datafile and $my_indexfile"
			delete $catalog
			delete $file
			return
		}

		if { $data_hdr(cname)!=$index_hdr(cname) } {
			set response_(code) 500
			#response:  internal server error
			puts "Cname fields don't match \
					in $my_datafile and $my_indexfile"
			delete $catalog
			delete $file
			return
		}

		if { $data_hdr(name)!=$index_hdr(name) } {
			set response_(code) 500
			#response:  internal server error
			puts "Name fields don't match in \
					$my_datafile and $my_indexfile"
			delete $catalog
			delete $file
			return
		}

		$file close



		if [info exists session_($address/$port)] {
			puts "session existed"
			set session $session_($address/$port)
		}  else {
			puts "session didn't exist"
puts /$data_hdr(protocol)
			if {[catch {set session \
					[new ArchiveSession/Play/$data_hdr(protocol) \
					$data_hdr(media) $address/$port/none/$ttl] } error]} {
				set response_(code) 500
				#response: internal server error
				# -name problem ?
				puts "Couldn't create session $data_hdr(protocol) $data_hdr(media) $address/$port/none/$ttl"
				return
			}
			set session_($address/$port) $session
		}


		set df [new ArchiveFile/Data]

		set if [new ArchiveFile/Index]

		$df open $my_datafile
		$if open $my_indexfile

		set stream [$session create_stream]

		$stream datafile $df

		$stream indexfile $if

		$stream lts $lts_($sess_id_)

		$session attach_stream $stream

		if {$start_($sess_id_) == "max"} {
			puts "In 1"
			set start_($sess_id_) $data_hdr(start)
			puts "Setting start: $data_hdr(start)"
			if [catch {$lts_($sess_id_) now_logical $data_hdr(start)} error] {
			set $response_(code) 500
			#response: internal server error
			puts "Bad start time"
			#return
			}
		} else {
			puts "In 2"
			if {$data_hdr(start) < $start_($sess_id_)} {
				set start_($sess_id_) $data_hdr(start)
				puts "Setting start: $data_hdr(start)"
				if [catch {$lts_($sess_id_) now_logical $data_hdr(start)} error] {
					set $response_(code) 500
					#response: internal server error
					puts "Bad start time"
					#return
				}
			}

		}


	}



	delete $catalog

	set response_(code) 200

	return


}




RTSPWorker instproc parse_setup {} {
	$self instvar params_
	$self instvar options
	$self instvar response_

	if [info exists params_(Transport)] {
		set transport $params_(Transport)
	} else {
		set response_(code) 400
		return -1
	}
	set fields [split $transport "; "]
	# Fix this whitespace prob

	puts "Fields: $fields"
	set first_field [split [lindex $fields 0] /]
	set options(protocol) [lindex $first_field 0]
	#some check here
	set options(profile) [lindex $first_field 1]
	#some check here
	if {[lindex $first_field 2] != ""} {
		set options(lower_transport) [lindex $first_field 2]
		#some check here
	}
	set len [llength $fields]

	for {set n 1} {$n < $len} { incr n} {
		set curr_field [split [lindex $fields $n] =]
		if {[lindex $curr_field 1] == ""} {
			set options([lindex $curr_field 0]) True
			#puts "OPTIONS SET: [lindex $curr_field 0]"
		} else {
			set options([lindex $curr_field 0]) [lindex $curr_field 1]
			#puts "OPTIONS SET: [lindex $curr_field 0] [lindex $curr_field 1] "
		}
	}

	set datafile_line $params_(uri)
	#puts $params_(uri)
	regexp {(rtsp://[a-z\.\:0-9]+)/(.+)} $params_(uri) junk junk2 filename

	#regexp {(rtsp://[a-z\.]+)/(.+)\.([a-z]+$)} $params_(uri) junk junk2 datafile extension
	#regexp {(.+)(\.[a-z]*$)} $params_(uri) a b c
	#regexp {(.+)((\.)*[a-z]*$)} $params_(uri) a b c
	#set cat [regexp {.ctg} $params_(uri)]
	#puts "catalog $cat"

	#puts "filename $filename"

	return $filename
}


RTSPWorker instproc do_setup {} {
	$self instvar params_
	$self instvar options
	$self instvar lts_
	$self instvar response_
	$self instvar start_
	$self instvar sess_id_ from_

	set filename [$self parse_setup]
	puts "Filename: $filename"

	if {$filename==-1} {
		return
	}

	if { ! [info exists lts_($sess_id_)] } {
		set lts_($sess_id_) [new LTS]
		set start_($sess_id_) max
		puts "new lts: lts_($sess_id_)"

	}

	if { [array get options multicast] == "unicast"} {
		set address [localaddr]
		puts "address= $address"
	} else {
		if [catch {set address $options(destination)} error] {
			set response_(code) 451
			#response: parameter not understood
			puts "No destination address"
			return 0

		}
	}
	if { ! [info exists address] } {
		puts "No destination address"
		set response_(code) 451
		return 0
		#Handle error, do same for port
	}

	if [catch {set port $options(port)} error] {
		set response_(code) 451
		#response: parameter not understood
		puts "No port"
		return 0
	}

	if [catch {set ttl $options(ttl)} error] {
		set ttl 16
		# ??
	}


	if { [catch {open $filename.dat r} error] } {
		puts "$filename.dat doesn't exist"

		regexp {(.+)/(.+)} $filename all first sessname

		$self setup_ctg $first.ctg $sessname $address $port $ttl

	} else {

		$self setup_stream $filename $address $port $ttl
	}

	puts "End of do_setup $response_(code)"
	return

}

