# temp_fx.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application

Class TempFXApp -superclass Application

TempFXApp instproc init {args} {
    $self next temp_fx_app

    $self init_resources

    eval [$self options] parse_args $args;

    if {[$self get_option subprogram] == ""} {
	puts stderr "Must specify subprogram";
	exit;
    }

    $self instvar my_addr_ node_spec_ ts_pid_ ti_pid_ proc_pids_ my_port_

    set my_addr_ [string trim [exec hostname]];
    set habbr [lindex [split $my_addr_ .] 0];
    set my_port_ [$self get_option glurun_client_port];

    set server_fd_ [socket -server "$self handle_client_registration" $my_port_];
    set my_port_ [lindex [fconfigure $server_fd_ -sockname] 2];

    set node_spec_ all-${habbr}-clump0-clump1-clump2-clump3
    global env
    set env(GLUNIX_NODES) $node_spec_

    set ts_pid_ [$self StartProc [$self get_option ts_prog] -cntrl_spec [$self get_option cntrl_spec]]
    set ti_pid_ [$self StartProc [$self get_option ti_prog] -cntrl_spec [$self get_option cntrl_spec]]

    for {set p 0} {$p < [$self get_option num_nodes]} {incr p} {
	set proc_pids_($p) [$self StartProc [$self get_option proc_prog] -subprogram [$self get_option subprogram] -reg_comm_spec [$self get_option cntrl_spec]];
    }

    # Create AS Service communication object.

    $self instvar service_al_;

    set service_al_ [new AnnounceListenManager/AS/Service/TempFXService $self [$self get_option as_spec] [$self get_option as_bw] [$self get_option serv_inst]];
}

TempFXApp instproc handle_client_registration {sfd addr port} {
    $self instvar client_sock_fd_;

    set client_sock_fd_ $sfd;
}

TempFXApp instproc init_resources {} {

    $self add_option num_nodes 4
    $self add_option subprogram ""
    $self add_option cntrl_spec 224.3.2.1/22334/16
    $self add_option as_spec 224.4.5.24/50000/16
    $self add_option smash_bin /home/cs/kpatel/mash-code/production/smash
    $self add_option ts_prog /home/cs/kpatel/mash-code/production/tcl/psvp/test2/fx_tselect.tcl
    $self add_option ti_prog /home/cs/kpatel/mash-code/production/tcl/psvp/test2/fx_tinter.tcl
    $self add_option proc_prog /home/cs/kpatel/mash-code/production/tcl/psvp/test2/fx_proc.tcl
    $self add_option glurun_client_port 0
    $self add_option glurun_client /home/cs/kpatel/mash-code/production/tcl/psvp/demos/glurun-client.tcl
    $self add_option as_bw 20000
    $self add_option serv_inst temp_fx_app

    [$self options] register_option -num_nodes num_nodes
    [$self options] register_option -subprogram subprogram
    [$self options] register_option -cntrl_spec cntrl_spec
    [$self options] register_option -as_spec as_spec
    [$self options] register_option -smash_bin smash_bin
    [$self options] register_option -ts_prog ts_prog
    [$self options] register_option -ti_prog ti_prog
    [$self options] register_option -proc_prog proc_prog
    [$self options] register_option -glurun_client_port glurun_client_port
    [$self options] register_option -as_bw as_bw
    [$self options] register_option -serv_inst serv_inst
    [$self options] register_option -megactrl as_spec
}

TempFXApp instproc exit {} {
    $self instvar ts_pid_ ti_pid_ proc_pids_ pid_map_;

    catch "puts $pid_map_($ts_pid_) {exit}"
    catch "flush $pid_map_($ts_pid_)";
    catch "close $pid_map_($ts_pid_)";

    catch "puts $pid_map_($ti_pid_) {exit}"
    catch "flush $pid_map_($ti_pid_)";
    catch "close $pid_map_($ti_pid_)";

    foreach i [array names proc_pids_] {
	catch "puts $pid_map_($proc_pids_($i)) {exit}"
	catch "flush $pid_map_($proc_pids_($i))";
	catch "close $pid_map_($proc_pids_($i))";
    }

    exit;
}

TempFXApp instproc StartProc {cmd args} {
    $self instvar client_sock_fd_ my_addr_ my_port_

    set client_sock_fd_ "";

    set pid [eval exec glurun [$self get_option smash_bin] [$self get_option glurun_client] $my_addr_ $my_port_ $cmd $args &];

    while {$client_sock_fd_ == ""} {
	update;
    }

    set client_host [gets $client_sock_fd_]

    $self instvar node_spec_

    set node_spec_ "$node_spec_-${client_host}"
    global env
    set env(GLUNIX_NODES) $node_spec_

    $self instvar pid_map_

    set pid_map_($pid) $client_sock_fd_;

    return $pid;
}

#############################
# Under here is our subclass of AnnounceListenManager/AS/Service
# which registers us with the host manager and all that. The important
# routine is unregister which tells us we can kill ourself.
#

import AnnounceListenManager/AS/Service

Class AnnounceListenManager/AS/Service/TempFXService -superclass AnnounceListenManager/AS/Service

AnnounceListenManager/AS/Service/TempFXService instproc unregister { atype aspec addr \
                srv_name srv_inst msg } {
        $self instvar agentbytype_ srv_inst_ agenttab_

        # If we are alive and a client with a different SID died --
        # no need to check.
        if { $atype != "client" || $srv_inst != $srv_inst_ } {
                return
        }
        foreach aspec $agentbytype_(client) {
                set sid [lindex $agenttab_($aspec) 4]
                if { $sid == $srv_inst_ } {
                        # Still have a client
                        return
                }
        }
        # No clients with our SID, exit

        puts stderr "no more clients -- exiting"

	$self instvar agent_

	$agent_ exit;
}

AnnounceListenManager/AS/Service/TempFXService instproc service_name {} {
    return "FXTemp"
}

AnnounceListenManager/AS/Service/TempFXService instproc send_announcement {} {
    puts "TempFXService sending announcement"
    $self next
}

AnnounceListenManager/AS/Service/TempFXService instproc recv_mesg {args} {

    puts "TempFXService recv_mesg: $args"
    eval $self next $args
}


#############################

set app [new TempFXApp $argv];

puts "Started"

if {![info exists tk_version]} {
    vwait forever;
}
