# pan_and_scan.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DaliSubprogram
import RectSubregionParameter

Class PanAndScanSubprogram -superclass DaliSubprogram

PanAndScanSubprogram instproc init {args} {
    eval $self next $args;

    # Set up inputs

    $self instvar input_id_list_;
    $self instvar input_info_;

    lappend input_id_list_ i1

    set input_info_(i1,spec) "";
    set input_info_(i1,trigger) 0;
    set input_info_(i1,buffertype) Uncompressed;
    set input_info_(i1,buffername) [new VidRep/Uncompressed];
    set input_info_(i1,decoder) "";

    # Set up outputs

    $self instvar output_id_list_;
    $self instvar output_info_;

    lappend output_id_list_ o1;

    set output_info_(o1,spec) "";
    set output_info_(o1,buffertype) Uncompressed;
    set output_info_(o1,buffername) [new VidRep/Uncompressed];
    set output_info_(o1,encoder) "";
    set output_info_(o1,format) H261;
    set output_info_(o1,vagent) "";

    # Set up parameters

    $self instvar parameter_id_list_;
    $self instvar parameter_info_;

    lappend parameter_id_list_ roi
    set pobj [new RectSubregionParameter];
    set parameter_info_(roi,oname) $pobj;
    $pobj set [list 0.0 0.0 1.0 1.0];

    $self instvar comm_obj_;
    $comm_obj_ setup;
}

PanAndScanSubprogram instproc trigger {} {
    $self instvar comm_obj_;

    if {![$comm_obj_ parameter_attr_has_value roi value]} {
	return;
    }

    $self instvar parameter_info_;
    $self instvar input_info_;
    $self instvar output_info_;
    $self instvar init_done_;
    $self instvar old_roi_;
    $self instvar la lb lc ld le lf ca cb cc cd ce cf

    set roi_obj $parameter_info_(roi,oname);
    set roi_coords [$roi_obj get];

    set in_frame $input_info_(i1,buffername);
    set out_frame $output_info_(o1,buffername);

    if {![info exists init_done_]} {
	if {[$in_frame set w_] == 0} {
	    return;
	}
	$out_frame copy_geometry $in_frame;
	if {$output_info_(o1,format) == "JPEG"} {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 1;
	} else {
	    $out_frame set h_subsample_ 2;
	    $out_frame set v_subsample_ 2;
	}
	$out_frame allocate;
	set init_done_ 1;
	set old_roi_ "";
    }

    if {$old_roi_ != $roi_coords} {
	set w [$in_frame set w_];
	set h [$in_frame set h_];

	set in_h_sub [expr 1.0*[$in_frame set h_subsample_]]
	set in_v_sub [expr 1.0*[$in_frame set v_subsample_]]
	set out_h_sub [expr 1.0*[$out_frame set h_subsample_]]
	set out_v_sub [expr 1.0*[$out_frame set v_subsample_]]

	set roi_x1 [lindex $roi_coords 0];
	set roi_x2 [lindex $roi_coords 2];
	set roi_y1 [lindex $roi_coords 1];
	set roi_y2 [lindex $roi_coords 3];

	if {$roi_x2 == $roi_x1} {
	    set roi_x2 [expr $roi_x2+0.01];
	}
	if {$roi_y2 == $roi_y1} {
	    set roi_y2 [expr $roi_y2+0.01];
	}

	set sx [expr 1.0 / ($roi_x2 - $roi_x1)];
	set sy [expr 1.0 / ($roi_y2 - $roi_y1)];

	set tx [expr $roi_x1 * $w * -1];
	set ty [expr $roi_x1 * $h * -1];

	set la $sx;
	set lb 0.0;
	set lc [expr $tx*$sx];
	set ld 0.0;
	set le $sy;
	set lf [expr $ty*$sy];

	set ca [expr $sx];
	set cb 0.0;
	set cc [expr $tx*$sx/$in_h_sub];
	set cd 0.0;
	set ce [expr $sy];
	set cf [expr $ty*$sy/$in_v_sub];

	set old_roi_ $roi_coords;
    }

    set in_l [$in_frame get_lum_name];
    set in_cr [$in_frame get_cr_name];
    set in_cb [$in_frame get_cb_name];

    set out_l [$out_frame get_lum_name];
    set out_cr [$out_frame get_cr_name];
    set out_cb [$out_frame get_cb_name];

    byte_affine $in_l $out_l $la $lb $lc $ld $le $lf;
    byte_affine $in_cr $out_cr $ca $cb $cc $cd $ce $cf;
    byte_affine $in_cb $out_cb $ca $cb $cc $cd $ce $cf;

    $out_frame set ts_ [$in_frame set ts_];

    set encoder $output_info_(o1,encoder);

    if {$encoder != ""} {
	$encoder recv $out_frame;
    }

    $self send_completion_token

    [[[[$input_info_(i1,decoder) set agent_] set network_] set net_(0)] set dn_] recv_flush

}

