# ztrace.tcl --
#
#       Buffer output until a SIGINT is caught; when caught, flush the output
#       and exit. The implementation that allows the ZTrace object to be
#       "compiled away" is from Yatin's MTrace impl.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  $Header: /usr/mash/src/repository/mash/mash-1/tcl/common/ztrace.tcl,v 1.5 2002/02/03 04:25:43 lim Exp $


# Check if the ZTrace object exists, if it doesn't, then just create a NULL
# ZTrace method.

#Class ZTrace -- import needs this comment so it can find C++ defined objs

if { [Class info instances ZTrace]=="" } {
    proc ZTrace { args } {
	    # ZTracing not enabled so define
	    # this method to do nothing
	    return ZTrace
    }
}

ZTrace proc init { } {
	ZTrace instvar ztrace
	set ztrace [new ZTrace]
}

proc ztrace { args } {
	ZTrace instvar ztrace
	if [info exists ztrace] {
		$ztrace trace $args
	}
}

