# nam-pkt.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#---------------------------------------------------------------------------
# NamPkt --
#       A packet in Nam knows how to draw itself
#
Class AnmObj/NamPkt -superclass AnmObj

AnmObj/NamPkt instproc init {eId sT eT pos delay xmitT pktHt attr color pktId} {
        $self next $eId $sT $eT

        $self instvar attr_ sT_ xmitT_ convId_ pktId_ color_ arrvT_ delay_
        set attr_ $attr
        set arrvT_ [expr $sT + $delay]
        set xmitT_ $xmitT
        set color_ $color
        set pktId_ $pktId
        set delay_ $delay
        eval $self inst_xform $pos $pktHt
        $self set bbox_ $pos
}

AnmObj/NamPkt instproc destroy {} { $self next }

AnmObj/NamPkt instproc inst_xform {x0 y0 x1 y1 pktHt} {
        set dx [expr $x1 - $x0]
        set dy [expr $y1 - $y0]

        $self instvar sx_ sy_ vx_ vy_ nx_ ny_ delay_ arrowOffset_
        set sx_ $x0
        set sy_ $y0

        #[vx, vy] is the parallel vector, in units of delay_
        set vx_ [expr $dx/$delay_]
        set vy_ [expr $dy/$delay_]

        #[nx, ny] is the normal vector in units of pktHt_/delay_
        set nx_ [expr $vy_ * $pktHt * (-1)]
        set ny_ [expr $vx_ * $pktHt]

        set arrowOffset_ [expr 0.75 * $pktHt]
}

####################################################################3
# AnmObj/NamPkt instproc xform --
#
# tail and head is in [0, delay],
#
#                                  | ^   ->
#                                  | |  norm
#  --------------------------------+
#             ->
#            vec_
#
#       tail      head - arrowOffset      x1 = head - arrowOffset_
#   y2  +-------------                    y2 = 1.5 (pktHt unit)
#       |              \
                #   y1  |                +                y1 = 1.0 (pktHt unit)
#       |
#   y0  +------------- /                  y0 = 0.5 (pktHt unit)
#                        head
#
AnmObj/NamPkt instproc xform {x y} {
        $self instvar vx_ vy_ sx_ sy_ nx_ ny_

        return [list [expr $sx_ + $x*$vx_ + $y*$nx_] \
                        [expr $sy_ + $x*$vy_ + $y*$ny_]]
}

AnmObj/NamPkt instproc compute_poly {tail head doarrow} {
        $self instvar arrowOffset_

        # change the coordinates
        set p0 [$self xform $tail 0.6]
        set ax [expr $doarrow ? ($head - $arrowOffset_) : $head]
        if {$ax < $tail} { set ax $head }
        set p1 [$self xform $ax 0.6]
        if {!$doarrow} {
                set p2 ""
        } else {
                set p2 [$self xform $head 1.2]
        }
        set p3 [$self xform $ax 1.8]
        set p4 [$self xform $tail 1.8]
        return [concat $p0 $p1 $p2 $p3 $p4]
}

#
#     xmitTime    edge delay
# | --------- | -------------|
# startTime               arrvTime
#
#
#           0 |---------------------------| delay
#           FIXME
#           tail    head   (tail and head is in [0,delay])
#
AnmObj/NamPkt instproc draw {now} {
        if ![$self inRange $now] {
                $self remove
                return
        }
        $self instvar sT_ xmitT_ arrvT_ drawboard_ color_

        # compute startpt and endpt of packet on link
        set arrow 1
        if {$now < $arrvT_} {
                set head [expr $now - $sT_]
        } else {
                set arrow 0
                set head [expr $arrvT_ - $sT_]
        }
        set tail [expr $now - $xmitT_ - $sT_]
        if {$tail < 0} {
                set tail 0
        }
        #DbgOut "$self p:[$self set pktId_] t:$tail  h:$head d:[$edge_ get_delay]"

        eval $drawboard_ poly $color_ \
                        [$self compute_poly $tail $head $arrow]
        if {$arrow} {
                eval $drawboard_ text \
                                [$self xform $head 3.0] 0 [$self set pktId_]
        }

        #DbgOut "drawing pkt $self at $now"
}
