# archive-system-mon.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/archive/archive-system-mon.tcl,v 1.4 2002/02/03 04:25:07 lim Exp $


import ArchiveSystem/Record Observer Observable

# Used in distribued recording and any other applications which need
# notification of recording quality
Class ArchiveSystem/Record/Monitored -superclass {ArchiveSystem/Record Observer Observable}

# Notification from rtp-record that a new stream has appeared
ArchiveSystem/Record/Monitored public new_stream { stream } {

	$self instvar streams_ threshold_

	lappend streams_ $stream
        $stream attach_observer $self
	if { [info exists threshold_] } {
		# Ask to be notified if the error rate rises above threshold
		$stream set_trigger $threshold_ 1
	}

}

ArchiveSystem/Record/Monitored public record_rtp_session { spec media tag } {
	$self instvar sessions_

	$self next $spec $media $tag
	set session [lindex $sessions_ end]
	$session attach_observer $self
}

ArchiveSystem/Record/Monitored public record_program { program tag } {

	$self instvar program_

	set program_ $program
	$self next $program $tag

}

# Called from Aries
ArchiveSystem/Record/Monitored public get_ssd {} {
	$self instvar sessions_ streams_

	set erlist ""
	# Do we need to id the session too?
	if [info exists streams_] {
		foreach s $streams_ {
			set er [$s error_rate]
			set stream_ssrc [$s ssrc]
			#puts "ER: $er SSRC: $stream_ssrc"
			set erlist "$stream_ssrc $er\n$erlist"
		}
	}
	#puts "%%%%%%%%%%%%%%%%%%%%%%%"
	#puts $erlist
	#puts "%%%%%%%%%%%%%%%%%%%%%%%"
	return $erlist
}


# Called by application to set an error threshold for notification
# threshold is checked in rtp-record.cc.  Used to trigger distributed
# recording
ArchiveSystem/Record/Monitored public set_thresh {thresh} {
	$self instvar threshold_

	set threshold_ $thresh

}

# Called from rtp-record.cc.  location should be the nearest platform to
# the source.
ArchiveSystem/Record/Monitored public loc {location ssrc} {
	$self instvar loc_
	set loc_($ssrc) $location
}

# Called from rtp-record.cc.  Fallen below the thresh set in set_thresh.
ArchiveSystem/Record/Monitored public below_thresh {ssrc} {
	$self instvar streams_ program_ threshold_ loc_

	if [info exists streams_] {
		foreach s $streams_ {
			set stream_ssrc [$s ssrc]
			#  Need to know which stream notified us
			if {$stream_ssrc == $ssrc &&  [info exists loc_($ssrc)]} {
				$self notify_observers higher_quality $program_ $loc_($ssrc)
				$s set_trigger $threshold_ 1
			}
		}
	}
}


# Called from rtp-record.cc.  Risen above the thresh set in set_thresh.
ArchiveSystem/Record/Monitored public above_thresh {ssrc} {
	$self instvar streams_ program_ threshold_ loc_

	if [info exists streams_] {
		foreach s $streams_ {
			set stream_ssrc [$s ssrc]
			#  Need to know which stream notified us
			if {$stream_ssrc == $ssrc &&  [info exists loc_($ssrc)]} {

				$self notify_observers low_quality $program_ $loc_($ssrc)
				$s set_trigger $threshold_ 0
			}
		}
	}
}

