/*
 * ns-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_ns_h
#define srmv2_ns_h

#include "tclcl.h"
#include "source-srmv2.h"
#include "module.h"
#include "srmv2.h"
#include "supp-srmv2.h"
#include "ns-map.h"

#define MAX_LOGLEN 32
#define MAX_NLEN   16

/*
 * An adubuf is a buffer that the application and SRMv2 share to exchange
 * data while sending, receiving, etc. ADU's are of variable length and
 * the length is unknown at the receiver until the last fragment arrives.
 */
class adubuf {
public:
	adubuf();
	adubuf(unsigned int length);
	~adubuf();
	void copy(unsigned char *buffer, int buflen);
	void append(unsigned *buffer, int buflen);
	void insert(pktbuf *pb);
	int  contiguous();
	int  concatenate();

	int len;		/* number of bytes that the app can read */
	int unused;
	unsigned int seqno;
	unsigned char *data;
	unsigned char *dp;
	pktbuf        *fraglist;
	int lastseen;
};


/*
 * NS_Node contains an array of pointers to ADU buffers used during
 * reassembly. adubuf is a structure for reassembly and passing
 * up to the application.
 */
class NS_Node {

public:
	NS_Node(unsigned int oid, int max_degree = 50, int max_dbufs = 100);
	~NS_Node();

	/* Used by the original source and receivers. */
	NS_Node*  calloc(unsigned int cid, int *created); /* alloc container */
	void      cid(unsigned id) { cid_ =  id; } /* FIXME assign an id */
	unsigned  int getcid() { return cid_; }	/* return our cid */
	adubuf* get_nodeinfo();

	NS_Node*  is_child(unsigned int cid);   /* is this cid our child? */
	NS_Node*  child(unsigned int n); /* Return child #n */
	unsigned int degree() { return degree_; }

	int lastseen(unsigned int seqno) { return dbufs_[seqno].lastseen; }
	void set_lastseen(unsigned int seqno) { dbufs_[seqno].lastseen = 1; }
	int match_signature(SRMv2_Edge* signature);

	/* Used by receivers alone. */
	void writef(pktbuf *pb, SRMv2_Source* src, SRMv2_Session* session,
			   unsigned int seqno, Bool eoa); /* write fragment */
	adubuf*   reassemble(int seqno); /* reassemble fragment */
	int check_holes(SRMv2_Source* src, SRMv2_Session* session,
			 SRMv2_Edge& left_edge, Bool eoa);
	void compute_signature();
	SRMv2_Edge* signature() { return &signature_; }
	void regadu(unsigned int seqno, unsigned int ebytes);
	void display(int indent);
	SRMv2_SuppQueue* requests() { return &requests_; }
	SRMv2_SuppQueue* replies() { return &replies_; }
	void set_edge(unsigned int a, unsigned int b);
private:
	int       degree_;	/* number of children */
	int       max_degree_;	/* max number of children before realloc */
	int       ndbufs_;	/* number of data buffers under me */
	int       max_dbufs_;	/* max number of data buffers */
	unsigned  int cid_;	/* container id */
	SRMv2_Edge signature_; /* unique 32-bit fingerprint */
	NS_Node** child_;	/* array of children */
	adubuf*   dbufs_;       /* Index into reassembly buffers */
	SRMv2_Edge expected_;

	SRMv2_SuppQueue requests_;	/* pending (scheduled) repair requests */
	SRMv2_SuppQueue replies_;	/* pending (scheduled) repairs */
};

class SRMv2_NameSpace : public TclObject {
public:
	SRMv2_NameSpace(NameMap *map, unsigned int root = 0);
	~SRMv2_NameSpace() { }
	int command(int argc, const char*const* argv);

	NS_Node* calloc(unsigned int parent, int *created, unsigned int cid=0);
	unsigned int sign(unsigned int cid);
	NS_Node *root() { return root_; }
	void compute_signature();
	unsigned int cid() { return cid_; }

private:
	NS_Node*    root_;
	NameMap*    namemap_;
	timeval     generation_;
	NS_Node**   map_;
	unsigned int cid_;
};

#endif

