/*
 * appmgr-srm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

// 	$Id: appmgr-srm.cc,v 1.14 2002/02/03 04:16:51 lim Exp $

#include "appmgr-srm.h"
#include "srm.h"
#include  <fcntl.h>

static class SRM_AppMgrClass : public TclClass {
public:
    SRM_AppMgrClass() : TclClass("SRMAppMgr") {}
    TclObject* create(int /*argc*/, const char*const* argv) {
	return new SRM_AppMgr((SRM_Packet*)TclObject::lookup(argv[4]));
    }
} srm_appmgr_class;


SRM_AppMgr::SRM_AppMgr(SRM_Packet *pkt) :
    app_seqno_ (0),
    ss_(0)

{
    t_dat_ = new u_char[2 * SRM_MTU];
    sp_    = pkt;

}


SRM_PacketHandler* SRM_AppMgr::new_source(const srm_src &/*id*/,
					  int /*islocal*/)
{
    return (0);
}

int SRM_AppMgr::next_ADU(u_char *dp, int /*len*/, srm_src& id, int &pkt_type,
			 int& next)
{

    // This is  a test application!
    // We omit the check for exceeding len.
    // MBoard should do this.
    pktbuf *p = (sp_->data());
    int dlen = p->len;
    memcpy(dp, p->data, dlen);

    pkt_type = SRM_REQUEST;
    next = 0;
    app_seqno_ ++;

    // If this is a repair request, the application
    // fills in the appropriate source address

    id.ss_uid = 0;
    id.ss_addr = 0;
    return dlen;
}


int SRM_AppMgr::command(int argc, const char*const* argv)
{
    Tcl& tcl = Tcl::instance();
    if (argc == 3) {
	if ((!strcmp(argv[1], "ss")) || (!strcmp(argv[1], "attach_session"))) {
	    ss_ = (SRM_Session*)TclObject::lookup(argv[2]);
	    if (!ss_) {
		    tcl.add_error("Couldn't find session");
		    return TCL_ERROR;
	    }
	    return (TCL_OK);
	}
	if (strcmp(argv[1], "packet") == 0) {
	    sp_ = (SRM_Packet*)TclObject::lookup(argv[2]);
	    return (TCL_OK);
	}
    }
    if (argc == 2) {
	    if (!strcmp(argv[1], "session")) {
		    if (!ss_) {
			    tcl.add_error("Couldn't find session");
			    return TCL_ERROR;
		    }
		    tcl.result(ss_->name());
		    return (TCL_OK);
	    }
    }
    return (TclObject::command(argc, argv));
}

static class SRM_PacketClass : public TclClass {
public:
    SRM_PacketClass() : TclClass("Packet/SRM") {};
    TclObject* create(int argc, const char*const* argv) {
	return (new SRM_Packet(argv[argc - 1]) );
    }
} srm_packet_class;


SRM_Packet::SRM_Packet(const char *str) : t_dat_(0)
{
    t_dat_ = new pktbuf;
    strcpy((char*)t_dat_->data, str);
    t_dat_->len = strlen(str);
    printf("[PacketClass] str = %s (%d)\n", t_dat_->data, t_dat_->len);
}

int SRM_Packet::command(int argc, const char*const* argv)
{
    Tcl& tcl = Tcl::instance();
    char* cp = tcl.buffer();
    if (argc == 2) {
	if (strcmp(argv[1], "length") == 0) {
	    sprintf(cp, "%u", length());
	    tcl.result(cp);
	    return (TCL_OK);
	}
    }
    if (argc == 3) {

	if (strcmp(argv[1], "read-data") == 0) {
	    int len = strlen(argv[2]);
	    strcpy((char*)t_dat_->data, argv[2]);
	    t_dat_->dp = t_dat_->data;
	    printf("read-data: len = %d\n", len);
	    t_dat_->len = len;
	    return (TCL_OK);
	}
    }

    return (TclObject::command(argc, argv));
}


void SRM_AppMgr::handle_request(u_char * /*pb*/, int /*len*/) {
    //	printf("received repair request (%d)\n", len);
}
void SRM_AppMgr::handle_reply(u_char * /*pb*/, int /*len*/) {
    //	printf("received repair reply(%d)\n", len);
}


int SRM_AppMgr::periodic_update(u_char * /*buf*/) {
    /*printf("Periodic update called\n");
    return 10;*/
    return 0;
}

void SRM_AppMgr::handle_SA(u_char * /*buf*/, int /*len*/) {
    //printf("received a session announcement\n");
}

