/*
 * ps-win.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/ps/ps-win.cc,v 1.13 2002/02/03 04:14:18 lim Exp $";
#endif

#include "ps-win.h"
// for strtol
#include <stdlib.h>

int PostscriptWindow::generic_callback(ClientData cd, XEvent* ep)
{
	PostscriptWindow* p = (PostscriptWindow*)cd;
	return (p->check_event(ep));
}

static class PostscriptWindowClass : public TclClass {
public:
	PostscriptWindowClass() : TclClass("PostscriptWindow") {}
	TclObject* create(int argc, const char*const* argv) {
		if (argc != 5)
			abort();/*FIXME*/
		return (new PostscriptWindow(argv[4]));
	}
} class_pswin;

GC PostscriptWindow::gc_;

PostscriptWindow::PostscriptWindow(const char* path)
{
	TkWidget::init(path, /*FIXME*/"PSWin", 0, 0, PropertyChangeMask);
	atom_next_ = XInternAtom(Tk_Display(tk_), "NEXT", False);
	atom_page_ = XInternAtom(Tk_Display(tk_), "PAGE", False);
	atom_done_ = XInternAtom(Tk_Display(tk_), "DONE", False);
	/*FIXME*/
	pixmap_ = 0;

	if (gc_ == 0) {
		/*FIXME should use *background */
		XColor* c = Tk_GetColor(Tcl::instance().interp(), tk_,
					Tk_GetUid("white"));
		if (c == 0)
			abort();
		XGCValues v;
		u_long mask = GCForeground|GCBackground|GCGraphicsExposures;
		v.background = c->pixel;
		v.foreground = c->pixel;
		v.graphics_exposures = 0;
		gc_ = Tk_GetGC(tk_, mask, &v);
	}
	/*
	 * Have to use a generic event handler to capture
	 * ClientMessage events.  The tk event handler drops
	 * all client messages!  (except WM_PROTOCOLS and selection
	 * events which it processes internally)
	 */
	Tk_CreateGenericHandler(generic_callback, (ClientData)this);
}

PostscriptWindow::~PostscriptWindow()
{
	if (pixmap_ != 0)
		Tk_FreePixmap(Tk_Display(tk_), pixmap_);
}

/*FIXME need a GS subclass*/
void PostscriptWindow::gs_nextpage(Window mwin)
{
        XEvent xe;
        xe.xclient.type = ClientMessage;
        xe.xclient.display = Tk_Display(tk_);
        xe.xclient.window = mwin;
        xe.xclient.message_type = atom_next_;
        xe.xclient.format = 32;
        xe.xclient.data.l[0] = 0;
        xe.xclient.data.l[1] = 0;
        XSendEvent(Tk_Display(tk_), mwin, False, 0, &xe);
}

int PostscriptWindow::check_event(XEvent* ep)
{
	XEvent& e = *ep;
	if (e.type == ClientMessage) {
		if ((Drawable) e.xclient.data.l[1] != pixmap_)
			return (0);
		Window w = e.xclient.data.l[0];
		if (e.xclient.message_type == atom_page_) {
			Tcl::instance().evalf("%s recv-page %u", name(), w);
			return (1);
		} else if (e.xclient.message_type == atom_done_) {
			Tcl::instance().evalf("%s recv-done %u", name(), w);
			return (1);
		}
	}
	return (0);
}

void PostscriptWindow::draw()
{
	printf("draw\n");
	XCopyArea(Tk_Display(tk_), pixmap_, Tk_WindowId(tk_),
		  gc_, 0, 0, width_, height_, 0, 0);
}

void PostscriptWindow::update()
{
	printf("update\n");
	draw();
}

void PostscriptWindow::resize()
{
	/*FIXME check that size really changed? */
	if (pixmap_ != 0)
		Tk_FreePixmap(Tk_Display(tk_), pixmap_);
	pixmap_ = Tk_GetPixmap(Tk_Display(tk_), Tk_WindowId(tk_),
                               width_, height_, Tk_Depth(tk_));
	XFillRectangle(Tk_Display(tk_), pixmap_, gc_, 0, 0, width_, height_);
	Tcl::instance().evalf("%s resize", name());
}

int PostscriptWindow::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	if (argc == 2) {
		if (strcmp(argv[1], "pixmap-id") == 0) {
			tcl.resultf("0x%x", pixmap_);
			return (TCL_OK);
		}
	} else if (argc == 3) {
		if (strcmp(argv[1], "next-page") == 0) {
			gs_nextpage(strtol(argv[2], 0, 0));
			return (TCL_OK);
		}
	} else if (argc == 4) {
		if (strcmp(argv[1], "set-atom") == 0) {
			const char* atomName = argv[2];
			const char* value = argv[3];
			Atom atom = XInternAtom(Tk_Display(tk_),  atomName, False);
			XChangeProperty(Tk_Display(tk_), Tk_WindowId(tk_),
					atom,
					XA_STRING, 8, PropModeReplace,
					(u_char *)value, strlen(value));
			/*FIXME*/
#ifndef WIN32
			XFlush(Tk_Display(tk_));
#endif
			return (TCL_OK);
		}
	}
	return (TkWidget::command(argc, argv));
}
