/*
 * mbv2-adu.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2-adu.h,v 1.5 2002/02/03 03:17:08 lim Exp $
 */

#ifndef MASH_MBV2_ADU_H
#define MASH_MBV2_ADU_H


struct ADU_CmdGroup {
	u_int16_t groupType;        /* MBv2Item type */
	u_int16_t pad;              /* so that startCmd is 4-byte aligned */
	u_int32_t startCmd, endCmd;
};



struct ADU_CmdCreate {
	u_int32_t itemType;                 /* pageitem type */
	/* followed by a coord packet */
	/* followed by a page Item packet */
};


struct ADU_Coords {
	u_int32_t numPoints;
	MBv2Point points[0];            // numPoints number of Point
};


struct ADU_CmdMove {
	u_int32_t targetCmd;
	MBv2Point delta;
};


struct ADU_CmdCopy {
	u_int32_t targetCmd;
	u_int32_t targetCid;
};


struct ADU_CmdDelete {
	u_int32_t targetCmd;
};


struct ADU_CmdChars {
	u_int32_t createCmd;
	u_int16_t index;
	char chars[0];
	/* followed by padding so that packet is aligned at 4 bytes */
};


struct ADU_LineItem {
	u_int16_t width;
	u_int16_t arrow;
	MBv2Color color;
};


struct ADU_PolyItem {
	u_int16_t width;
	u_int16_t pad;
	MBv2Color fill;
	MBv2Color outline;
};


struct ADU_TextItem {
	MBv2Color color;
	u_int32_t justify;
	char font[0];
	/* followed by padding so that packet is aligned at 4 bytes */
};


#endif /* #ifdef MASH_MBV2_ADU_H */
