/*
 * atobj-sm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ATOBJ_SM_CC
#define ATOBJ_SM_CC

#include <mb/mb.h>

#ifndef lint
static const char rcsid[] = "$Header: /usr/mash/src/repository/mash/mash-1/atobj/atobj-sm.cc,v 1.15 2002/02/03 03:10:21 lim Exp $";
#endif

#include <mb/mb-nethost.h>
#include "atobj-sm.h"

extern "C"
{
#include <inet.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <sys/types.h>
};

#include <misc/mtrace.h>

// this is a simple animator session manager
static class AtoSMClass : public TclClass {
public:
        AtoSMClass() : TclClass("Atobj_sess_mgr") {
        }

        TclObject* create(int /*argc*/, const char*const* /*id*/) {
                return (new AtobjSM());
        }
} AtoSMC;

AtobjSM::AtobjSM()
        : SRM_AppMgr(NULL), pLocalRcvr_(NULL), pSession_(NULL)
{
        phtRcvrs_ = new Tcl_HashTable;
        if (!phtRcvrs_) {
                SignalError(("Out of Memory!"));
                abort();
        }
        // SrcId must be a of size a multiple of int
        // otherwise we would use garbage as part of the keys
        assert((sizeof(SrcId)/sizeof(int))*sizeof(int) == sizeof(SrcId));
        Tcl_InitHashTable(phtRcvrs_, sizeof(SrcId)/sizeof(int));
}

/*virtual*/
AtobjSM::~AtobjSM()
{
        Tcl_HashSearch hsearch;
        Tcl_HashEntry *pEntry = Tcl_FirstHashEntry(phtRcvrs_, &hsearch);
        Tcl& tcl=Tcl::instance();
        while (pEntry) {
                                // these are TclObjects have to do death from
                                // above
                AtobjRcvr *pRcvr = (AtobjRcvr *)Tcl_GetHashValue(pEntry);
                pEntry = Tcl_NextHashEntry(&hsearch);
                tcl.evalf("delete %s", pRcvr->name());
        }
        Tcl_DeleteHashTable(phtRcvrs_);
        delete phtRcvrs_;
}

// virtual SRM_AppMgr functions
SRM_PacketHandler *
AtobjSM::new_source(const srm_src &sid, int islocal)
{
        if (islocal) return NULL;
        return (SRM_PacketHandler*) define_rcvr(sid);
}

// checks if there is a receiver with such an id
AtobjRcvr* AtobjSM::get_rcvr(const SrcId& srcId)
{
        Tcl_HashEntry *pEntry = Tcl_FindHashEntry(phtRcvrs_, (char*)&srcId);
        if (!pEntry) return NULL;
        else return (AtobjRcvr*)Tcl_GetHashValue(pEntry);
}

AtobjRcvr* AtobjSM::define_rcvr(const SrcId& srcId)
{
        int created;
        Tcl& tcl=Tcl::instance();

        Tcl_HashEntry *pNewEntry =
                Tcl_CreateHashEntry(phtRcvrs_, (char*)&srcId, &created);
        if (created) {
                Trace(VERBOSE, ("creating new receiver: %d@%s",
                      srcId.ss_uid, intoa(srcId.ss_addr)));
                tcl.evalf("%s new_rcvr %lx %lx", name(), srcId.ss_uid,
                          srcId.ss_addr);
                AtobjRcvr* pRcvr =
                        (AtobjRcvr*)TclObject::lookup(tcl.result());
                Trace(VERBOSE, ("result: %x %d@%s",
                      pRcvr, srcId.ss_uid, intoa(srcId.ss_addr)));
                assert(pRcvr && "new receiver failed!");
                Tcl_SetHashValue(pNewEntry, (ClientData) pRcvr);
                return pRcvr;
        } else {
                return (AtobjRcvr*)Tcl_GetHashValue(pNewEntry);
        }
}

int AtobjSM::command(int /*argc*/, const char*const* argv)
{
        if (!strcmp(argv[1], "attach_session")) {
                SRM_Session* pSession =
                        (SRM_Session*)TclObject::lookup(argv[2]);
                if (!pSession) {
                        Tcl::instance().result("Couldn't find session");
                        return TCL_ERROR;
                }
                setSession(pSession);
        } else if (!strcmp(argv[1], "set_local_src")) {
                                // this is not a requirement, just something
                                // that I might assume
                assert(!pLocalRcvr_ && "shouldn't set local twice");
                pLocalRcvr_ = (AtobjRcvr*) TclObject::lookup(argv[2]);
                const SrcId& sid = pLocalRcvr_->srcId();
                fprintf(stderr, "localsrc is %s (%d@%s)\n",
                        pLocalRcvr_->name(),
                        sid.ss_uid, intoa(sid.ss_addr));
                if (!get_rcvr(sid)) {
                        int created;
                        Tcl_HashEntry *pNewEntry =
                                Tcl_CreateHashEntry(phtRcvrs_,
                                                    (char*)&sid, &created);
                        Tcl_SetHashValue(pNewEntry, (ClientData) pLocalRcvr_);
                }
                if (!pLocalRcvr_) {
                        Tcl::instance().result("Couldn't find local src");
                        return TCL_ERROR;
                }
        } else if (!strcmp(argv[1],"abort")) {
                assert(FALSE && "progam aborted");
                Tcl::instance().eval("exit");
        }
        return TCL_OK;
}

//
// handles a repair request from the net
//
/*virtual*/
void AtobjSM::handle_request(const SrcId& sidRqtSrc, Byte *pb, int /* len */)
{
        if (pLocalRcvr_ && pLocalRcvr_->srcId() == sidRqtSrc) {
                return;         // ignore own request
        }
        AtoPkt_request* pPkt = (AtoPkt_request*) pb;
        SrcId srcId;
        net2host(pPkt->pr_srcId, srcId);
        Trace(VERBOSE,("r rqt (%d B) fr %x@%s",
                       sidRqtSrc.ss_uid, intoa(sidRqtSrc.ss_addr)));

        AtobjRcvr *pRcvr = get_rcvr(srcId); // drop the request from ourselves
        if (pRcvr) pRcvr->handleRequest(pPkt);
        if (!pRcvr) Trace(VERBOSE,
                          ("request for data of unknown source %d@%s\n",
                           srcId.ss_uid, intoa(srcId.ss_addr)));
}

//
// handle a repair reply
//
/*virtual*/
#ifdef MB_DEBUG
void AtobjSM::handle_reply(const SrcId& sidRpySrc, Byte *pb, int len)
#else
void AtobjSM::handle_reply(const SrcId& sidRpySrc, Byte *pb, int /* len */)
#endif
{
        if (pLocalRcvr_ && pLocalRcvr_->srcId() == sidRpySrc) {
                return;         // ignore own request
        }
        AtoPkt_reply* pPkt = (AtoPkt_reply*) pb;
        SrcId srcId;
        net2host(pPkt->pr_srcId, srcId);
        Trace(VERYVERBOSE,("recv reply: %d bytes from %d@%s\n",len, srcId.ss_uid,
                           intoa(srcId.ss_addr)));

        AtobjRcvr *pRcvr = get_rcvr(srcId);
        if (pRcvr) pRcvr->handleReply(pPkt);
        if (!pRcvr) Trace(VERBOSE,("reply from unknown receiver: %d@%s\n",
                                   srcId.ss_uid, intoa(srcId.ss_addr)));

}

#ifdef MB_DEBUG
void AtobjSM::handle_SA(const SrcId& sid, Byte * pb, int len)
#else
void AtobjSM::handle_SA(const SrcId& sid, Byte * pb, int /* len */)
#endif
{
        if (pLocalRcvr_ && pLocalRcvr_->srcId()==sid) {
                return;         // ignore local sa's
        }
        AtoPkt_SA* pPkt = (AtoPkt_SA*) pb;
        SrcId srcId;
        net2host(pPkt->sa_srcId, srcId);
        if (srcId.ss_uid == 0 && srcId.ss_addr==0) {
                return;         // empty srcId
        }
        Trace(VERBOSE,("recv'd SA of %d bytes from %d@%s",
                           len, srcId.ss_uid, intoa(srcId.ss_addr)));
        AtobjRcvr *pRcvr = define_rcvr(srcId);
        assert(pRcvr);
        pRcvr->handleSA(pPkt);
        if (!pRcvr) Trace(VERBOSE,("SA from unknown receiver: %d@%s\n",
                                   srcId.ss_uid, intoa(srcId.ss_addr)));
}

// if a receiver has requested a SA, service them first, else
// ask the local receiver to send out the SA
int AtobjSM::periodic_update(Byte * pb)
{
        if (!pLocalRcvr_) return 0;

        // right now just use local receiver only
        // REVIEW: take care of initial start up problem
        int len = pLocalRcvr_->fillSA(pb);
        Trace(VERBOSE,("sending app sa: of %d bytes", len));
        return len;
}

#endif /* #ifdef ATOBJ_MGR_CC */
