###########################################################################################
# SQL Patch for OpenDb prior to OpenDb 0.31
#
# WARNING: Please be sure to make a backup of all data before proceeding with this patch...
###########################################################################################

#
# Update all IMAGEURL item_attributes to include 'http://' prefix!
# This is required for the new support for locally stored Cover images.  We need to be able to check for 
# the existence of 'http://' at the start of IMAGEURL attribute_val, to work out whether they are relative
# or not.
#
UPDATE item_attribute SET attribute_val = CONCAT('http://',attribute_val) WHERE s_attribute_type = 'IMAGEURL' AND attribute_val NOT LIKE 'http://%' AND LENGTH(TRIM(attribute_val)) > 0;

#
# Alter s_item_type
#
ALTER TABLE s_item_type DROP category_attribute_type;
ALTER TABLE s_item_type DROP image_attribute_type;
#
# Ordering of s_item_type's in Lists of Values, etc.
# The tinyint(2) unsigned limits the number of order_no to 100 (including 0)
#
ALTER TABLE s_item_type ADD order_no tinyint(2) unsigned AFTER default_site_type;

# Alter user table for future functionality.
ALTER TABLE user ADD language varchar(10) AFTER email;
ALTER TABLE user ADD theme varchar(10) AFTER language;

# Alter s_item_attribute_type.
ALTER TABLE s_item_attribute_type ADD s_field_type varchar(10) AFTER prompt;

ALTER TABLE borrowed_item CHANGE sequence_number sequence_number INTEGER(10) UNSIGNED NOT NULL auto_increment;
ALTER TABLE borrowed_item CHANGE item_id item_id INTEGER(10) UNSIGNED NOT NULL;
# Next 4 lines for Borrow Duration support.
ALTER TABLE borrowed_item ADD borrow_duration smallint(3) unsigned AFTER borrower_id;
ALTER TABLE borrowed_item ADD total_duration smallint(3) unsigned AFTER borrow_duration;
ALTER TABLE borrowed_item ADD instance_no SMALLINT(5) UNSIGNED NOT NULL AFTER item_id;
ALTER TABLE borrowed_item ADD INDEX borrowed_item_idx ( item_id, borrower_id );

# Do not drop item columns until after data has been migrated.
ALTER TABLE item CHANGE id id INTEGER(10) UNSIGNED NOT NULL auto_increment;
ALTER TABLE item CHANGE parent_id parent_id INTEGER(10) UNSIGNED;

# Alter review table
# Rename table so we can copy records over easily.
RENAME TABLE review TO review_old;

# Now recreate with changes a new empty table, where
# records will be transferred.
CREATE TABLE review (
  author_id	varchar(20) NOT NULL,
  item_id	integer(10) unsigned NOT NULL,
  comment	text,
  rating	varchar(1) NOT NULL,
  update_on	timestamp(14) NOT NULL,
  KEY author_item ( author_id, item_id )
) TYPE=MyISAM COMMENT='Item Reviews';

# Add item_instance table
CREATE table item_instance (
  item_id		bigint(10) unsigned NOT NULL,
  instance_no		smallint(5) unsigned NOT NULL,
  owner_id		varchar(20) NOT NULL,
  borrow_duration	smallint(3) unsigned,
  active_ind		varchar(1) NOT NULL default 'Y',
  update_on		timestamp(14) NOT NULL,
  PRIMARY KEY ( item_id, instance_no ),
  KEY owner_id ( owner_id )
) TYPE=MyISAM COMMENT='Item Instance table';

# Alter table item_attribute
ALTER TABLE item_attribute ADD update_on timestamp(14) NOT NULL AFTER attribute_val;
ALTER TABLE item_attribute CHANGE item_id item_id INTEGER(10) UNSIGNED NOT NULL;
ALTER TABLE item_attribute CHANGE order_no order_no TINYINT(3) unsigned NOT NULL;

# Alter table s_attribute_type_lookup
ALTER TABLE s_attribute_type_lookup CHANGE order_no order_no TINYINT(3) unsigned;
# Reduce s_attribute_type_lookup value column size
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(100) NOT NULL;

# Alter table s_item_attribute_type
ALTER TABLE s_item_attribute_type CHANGE order_no order_no TINYINT(3) unsigned NOT NULL;

################################################################################
# Now update item_attribute VHS type
################################################################################
UPDATE item_attribute SET s_attribute_type = 'VHS_TYPE' WHERE s_attribute_type = 'VHS_FORMAT';

# This attribute is the same as item.category anyway, so it is not needed.
DELETE FROM item_attribute WHERE s_attribute_type = 'CDDBGENRE';

################################################################################
# Now do the system data updates.
################################################################################
# because instance_no never existed before, it can be nothing but instance_no 1.
UPDATE borrowed_item
set instance_no = 1;

UPDATE s_attribute_type_lookup
set display = null
where s_attribute_type = 'RATIO';

DELETE from s_attribute_type_lookup
where s_attribute_type = 'MUSICGENRE'
and value = 'data';

UPDATE s_attribute_type_lookup
set display = 'Rock'
where s_attribute_type = 'MUSICGENRE'
and value = 'rock';

################################################################################
# Replace ORIG_TITLE attribute references with ALT_TITLE onces.
################################################################################
delete from s_attribute_type where s_attribute_type = 'ORIG_TITLE';

update item_attribute set s_attribute_type = 'ALT_TITLE'
where s_attribute_type = 'ORIG_TITLE';

update s_item_attribute_type set s_attribute_type = 'ALT_TITLE'
where s_attribute_type = 'ORIG_TITLE';
################################################################################

UPDATE 	s_attribute_type 
SET	input_type = 'number(4, %field% <i>minutes</i>)',
	display_type = 'format_mins(%h %H and %m %M)'
WHERE 	s_attribute_type = 'RUN_TIME';

# Composite category support
UPDATE s_attribute_type set input_type = 'checkbox_grid(%display%, 4)',
			display_type = 'category(%display%)'
WHERE s_attribute_type = 'MOVIEGENRE';

# single_select_or_value is no longer supported.
UPDATE s_attribute_type set input_type = 'single_select(%display%)'
WHERE s_attribute_type = 'MUSICGENRE';

# Subtitles input looks better with 4 wide grids
UPDATE s_attribute_type set input_type = 'checkbox_grid(%img% %display%, 4)'
WHERE s_attribute_type = 'SUBTITLES';

#
# By default the display_type of all input_type = 'hidden', should also be
# hidden, but only if display_type does not already have a value.
#
UPDATE s_attribute_type SET display_type = 'hidden' WHERE input_type = 'hidden' AND LENGTH(TRIM(display_type)) = 0;

INSERT INTO s_attribute_type_lookup(s_attribute_type, order_no, value, display, img, checked_ind) 
VALUES ( 'MUSICGENRE', NULL, 'pop', 'Popular', NULL, NULL);

#
# Update all IMAGEURL item_attributes to include 'http://' prefix!
# This is required for the new support for locally stored Cover images.  We need to be able to check for 
# the existence of 'http://' at the start of IMAGEURL attribute_val, to work out whether they are relative
# or not.
#
UPDATE item_attribute SET attribute_val = CONCAT('http://',attribute_val) WHERE s_attribute_type = 'IMAGEURL' AND attribute_val NOT LIKE 'http://%' AND LENGTH(TRIM(attribute_val)) > 0;

# Alternate title attribute
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ('ALT_TITLE', 'Original Title of film', 'Original Title', 'text(50)', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '2.78', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '2.20', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '1.78', NULL, NULL, NULL);

#
# This attribute is reserved for use in Borrow Duration functionality.  Please do not use it for your own s_item_attribute_type structures.
# If you want you could run this update to change the input type for S_DURATION a numeric input field instead:
# UPDATE s_attribute_type SET input_type = 'number(3, %field% <i>days</i>)' WHERE s_attribute_type = 'S_DURATION'
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_DURATION', 'Borrow Duration', 'Borrow Duration', 'single_select(%display%)', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '0', '', 'Undefined', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '1', '1', 'One Day', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '2', '3', 'Three Days', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '3', '7', 'One Week', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '4', '14', 'Two Weeks', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '5', '28', 'One Month', NULL, NULL);

#
# DIVX Support
#

INSERT INTO s_item_type (s_item_type, description, image, title_prompt, default_site_type, order_no) VALUES ( 'DIVX', 'DivX Video', 'divX.gif', NULL, 'imdb', '3');

# DivX Attributes
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXVIDVER', 'Video Codec Version', 'Video Codec', 'single_select(%display%)', '%display%', NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXAUDVER', 'Audio Codec Version', 'Audio Codec', 'single_select(%display%)', '%display%', NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXQUALIT', 'DIVX Quality', 'Quality', 'single_select(%display%)', '%display%', NULL); 

# Delete all records from s_item_attribute_type table, so they can be reinserted.
DELETE FROM s_item_attribute_type;

# Now reinsert them.
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'MOVIE_PLOT', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'DIRECTOR', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'ACTORS', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'MOVIEGENRE', '40', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'YEAR', '50', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'RUN_TIME', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AUDIO_LANG', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'SUBTITLES', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AGE_RATING', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'DVD_REGION', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'RATIO', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'VID_FORMAT', '120', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'DVD_EXTRAS', '130', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'IMDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_DURATION', '200', NULL, 'DURATION', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'MOVIE_PLOT', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'DIRECTOR', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'ACTORS', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'MOVIEGENRE', '40', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'YEAR', '50', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'RUN_TIME', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AUDIO_LANG', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'SUBTITLES', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AGE_RATING', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'RATIO', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'VID_FORMAT', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'COMMENTS', '120', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'IMDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_DURATION', '200', NULL, 'DURATION', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'MOVIE_PLOT', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'DIRECTOR', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'ACTORS', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'MOVIEGENRE', '40', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'YEAR', '50', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'RUN_TIME', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'SUBTITLES', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'AGE_RATING', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'VID_FORMAT', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'VIDQUALITY', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'COMMENTS', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'IMDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_DURATION', '200', NULL, 'DURATION', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'MOVIE_PLOT', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'DIRECTOR', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'ACTORS', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'MOVIEGENRE', '40', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'YEAR', '50', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'RUN_TIME', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'SUBTITLES', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'AGE_RATING', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'VID_FORMAT', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'VHS_TYPE', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'VIDQUALITY', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'COMMENTS', '120', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'IMDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_DURATION', '200', NULL, 'DURATION', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'ARTIST', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'MUSICGENRE', '20', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTIME', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'YEAR', '40', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '50', 'Track 1', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '51', 'Track 2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '52', 'Track 3', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '53', 'Track 4', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '54', 'Track 5', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '55', 'Track 6', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '56', 'Track 7', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '57', 'Track 8', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '58', 'Track 9', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '59', 'Track 10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '60', 'Track 11', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '61', 'Track 12', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '62', 'Track 13', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '63', 'Track 14', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '64', 'Track 15', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '65', 'Track 16', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '66', 'Track 17', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '67', 'Track 18', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '68', 'Track 19', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDTRACK', '69', 'Track 20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'FREEDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_DURATION', '200', NULL, 'DURATION', NULL);

# Disable this line in favour of specific Alternate title patch.
#INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'ALT_TITLE', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'MOVIE_PLOT', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIRECTOR', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'ACTORS', '40', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'MOVIEGENRE', '50', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'YEAR', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'RUN_TIME', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AUDIO_LANG', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'SUBTITLES', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AGE_RATING', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'RATIO', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXVIDVER', '120', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXAUDVER', '130', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXQUALIT', '140', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DVD_FORMAT', '150', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DVD_EXTRAS', '160', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'IMDB_ID', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_DURATION', '200', NULL, 'DURATION', NULL);

# Divx audio and video
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp3', 'Mp3', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp2', 'Mp2', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'ogg', 'Ogg', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx4', 'Divx4', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx3', 'Divx3 3.11 Alpha', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'angelpotion', 'Angel Potion Codec', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'poor', 'Poor', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'medium', 'Medium', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'Good', 'Good', NULL, NULL);

#
# This attribute is reserved for use in item_review.  Please do not use it for your own s_item_attribute_type structures.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_RATING', 'Item Rating', 'Rating', 'review_options(%display%, VERTICAL)', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '1', 'Disgraceful!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '2', 'Terrible!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '3', 'Decent!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '4', 'Great!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '5', 'Sensational!', NULL, NULL);

#
# Default order for all system item types.
#
UPDATE s_item_type set order_no = 0 where s_item_type = 'DVD';
UPDATE s_item_type set order_no = 1 where s_item_type = 'VHS';
UPDATE s_item_type set order_no = 2 where s_item_type = 'CD';
# DIVX has just been inserted, so order_no already set!
UPDATE s_item_type set order_no = 4 where s_item_type = 'VCD';
UPDATE s_item_type set order_no = 5 where s_item_type = 'LD';

#
# For performance reasons you should explicity set the display_type of any attributes where no comparison
# to lookup values is required.
#
UPDATE s_attribute_type SET display_type = '%value%' WHERE s_attribute_type IN('ALT_TITLE','COMMENTS','MOVIE_PLOT','CDTRACK','CDTIME');

#
# List Link functionality
#
UPDATE s_attribute_type SET display_type = 'display(%value%, list-link)' where s_attribute_type IN('YEAR','VID_FORMAT','DVD_REGION');
UPDATE s_attribute_type SET display_type = 'display(%display%, list-link)' where s_attribute_type IN('VIDQUALITY','VHS_TYPE','DIVXVIDVER','DIVXAUDVER','DIVXQUALIT');
UPDATE s_attribute_type SET display_type = 'display(%img% %display%, list-link)' where s_attribute_type IN('AUDIO_LANG', 'SUBTITLES');

# Do it for Director as well in case there is dual directorship!
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('DIRECTOR','ACTORS','ARTIST');
# The display(%value%, list-link) widget does not work for attributes which have more than one %value%.
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('RATIO');
UPDATE s_attribute_type SET display_type = 'display(%img%, list-link)' where s_attribute_type  = 'AGE_RATING';
UPDATE s_attribute_type SET display_type = 'category(%display%, list-link)' where s_attribute_type IN('MOVIEGENRE','MUSICGENRE');

#
# Save Covers locally functionality.
#
UPDATE s_attribute_type SET input_type = 'upload_or_saveurl(50,*,"gif,jpg,png")', display_type = 'hidden' WHERE s_attribute_type = 'IMAGEURL';

#
# Used to display item.id in item_display.php script.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_ITEM_ID', 'OpenDb Item ID', 'ID#', 'hidden', '%value%', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);

# Amazon dummy attribute - may never be used to populate records, but will allow addition of links to particular items.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'AMAZONASIN', 'Amazon Standard Item Number', 'Amazon ASIN', 'hidden', 'hidden', 'amazon');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'AMAZONASIN', '0', NULL, NULL, NULL);

