<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/function.php");
include_once("./functions/datetime.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/listings.php");
include_once("./functions/sortutils.php");
include_once("./functions/Listing.class.inc");

/**
	This function will get the next $borrowed_item_r/$item_r record
	based on whether we are dealing with a mysql resultset or a
	php array.

	Do not call this function once it returns FALSE.
 
	We need to pass the array 'pass-by-reference' so that the
	next operations affect the original array and not a copy!
*/
function next_record($result, &$item_reservation_rs)
{
	if(is_not_empty_array($item_reservation_rs))
	{
		// Ignore beyond end of array error.
		list(,$item_reservation_r) = @each($item_reservation_rs);
		if(is_not_empty_array($item_reservation_r))
		{
			// Iterate the array for next time
			return $item_reservation_r;
		}
		else
			return FALSE;
	}
	else //ignore any error.
	{
		return @mysql_fetch_array($result, MYSQL_ASSOC);
	}
}

/**
	This does a simple sort of the reserve basket array.  There is no
	reference to any other column in the sort order, only the
	primary one.

	Only supports sorting by:
		title,s_item_type,owner 
*/
function sort_item_reservation_rs(&$item_rs, $order_by, $sortorder)
{
	// 'create_function' was added in php 4.0.1.  This will allow OpenDb to
	// function adequately in php 4.0.0.  The data in the Reserve Basket will
	// ignore requests to sort in this case.
	if(function_exists("create_function"))
	{
		if($order_by == 's_item_type')
			$order_by_clause = "s_item_type $sortorder, title $sortorder, instance_no ASC, owner_id $sortorder";
		else if($order_by == 'title')
			$order_by_clause = "title $sortorder, instance_no ASC, type $sortorder, owner_id $sortorder";
		else if($order_by == 'owner')
			$order_by_clause = "owner_id $sortorder, title $sortorder, instance_no ASC, type $sortorder";
	
		usort($item_rs, create_function('$a,$b', get_usort_function($order_by_clause)));
	}		
}

session_start();
if(is_opendb_valid_session())
{
	if($CONFIG_VARS['borrow.enable']!==FALSE)
	{
		if (is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) ) // Only borrow users allowed
		{
			$listingObject = new Listing($HTTP_VARS['mode'], $CONFIG_VARS['borrow.navigation_form_method']);
			$listingObject->setItemsPerPage($CONFIG_VARS['listings.items_per_page']);
			
			$show_listings=TRUE;

			if($HTTP_VARS['op'] == "my_borrowed")//all titles that the person has actually borrowed from others.
			{
				$page_title = $LANG_VARS['my_borrowed_items'];
				$total_items = fetch_my_borrowed_item_cnt($HTTP_SESSION_VARS['user_id']);
				if($total_items>0)
				{
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_my_borrowed_item_rs(
										$HTTP_SESSION_VARS['user_id'], 
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == 'all_borrowed' && $CONFIG_VARS['borrow.list_all_borrowed']!==FALSE)
			{
				$page_title = $LANG_VARS['items_borrowed'];
				$total_items = fetch_all_borrowed_item_cnt();
				if($total_items>0)
				{
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_all_borrowed_item_rs(
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == 'all_reserved' && $CONFIG_VARS['borrow.list_all_reserved']!==FALSE)
			{
				$page_title = $LANG_VARS['items_reserved'];
				$total_items = fetch_all_reserved_item_cnt();
				if($total_items>0)
				{
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_all_reserved_item_rs(
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == "my_reserved")//all titles that the person has reserved from others.
			{
				$page_title = $LANG_VARS['my_reserved_items'];
				$total_items = fetch_my_reserved_item_cnt($HTTP_SESSION_VARS['user_id']);
				if($total_items>0)
				{
					$listingObject->setCheckBoxColumn('sequence_number', TRUE);
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_my_reserved_item_rs(
										$HTTP_SESSION_VARS['user_id'], 
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == "owner_borrowed")//all titles the owner currently has lent out to others.
			{
				$page_title = $LANG_VARS['item_check_in'];
				$total_items = fetch_owner_borrowed_item_cnt($HTTP_SESSION_VARS['user_id']);
				if($total_items>0)
				{
					$listingObject->setCheckBoxColumn('sequence_number', TRUE);
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_owner_borrowed_item_rs(
										$HTTP_SESSION_VARS['user_id'], 
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == "owner_reserved")//all titles the owner currently has reservations for.
			{
				$page_title = $LANG_VARS['item_check_out'];
				$total_items = fetch_owner_reserved_item_cnt($HTTP_SESSION_VARS['user_id']);
				if($total_items>0)
				{
					$listingObject->setCheckBoxColumn('sequence_number', TRUE);
					$listingObject->setTotalItems($total_items);
					$listingObject->initListing($HTTP_VARS);
					
					$result = fetch_owner_reserved_item_rs(
										$HTTP_SESSION_VARS['user_id'], 
										$HTTP_VARS['order_by'], 
										$HTTP_VARS['sortorder'], 
										$listingObject->getStartIndex(),
										$listingObject->getItemsPerPage());
				}
			}
			else if($HTTP_VARS['op'] == "my_item_history")
			{
				$show_listings=FALSE;
			
				$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
				if(is_not_empty_array($item_r))
				{
					// Cannot view item history, unless you are admin, or own the item.
					if(is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) || is_user_owner_of_item($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
					{
						$show_listings=TRUE;
					
						$page_title = replace_lang_var('display_title', expand_item_title_mask($item_r['title'], $item_r['s_item_type'], $item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['item_display.title_display_mask']), $LANG_VARS['history_for_title']);
						$page_image = get_item_image($item_r['s_item_type'], $item_r['item_id']);
					
						$total_items = fetch_item_instance_history_cnt($item_r['item_id'], $item_r['instance_no']);
						if($total_items>0)
						{
							$listingObject->setTotalItems($total_items);
							$listingObject->initListing($HTTP_VARS);
							
							$result = fetch_item_instance_history_rs(
											$item_r['item_id'], 
											$item_r['instance_no'], 
											$HTTP_VARS['order_by'], 
											$HTTP_VARS['sortorder'], 
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
						}
					}
					else
					{
						echo _theme_header($LANG_VARS['not_authorized_to_page']);
						echo _theme_error($LANG_VARS['not_authorized_to_page']);
					}
				
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
					if($HTTP_VARS['listing_link'] === "y" && is_not_empty_array($HTTP_SESSION_VARS['listing_url_vars']))
					{
						$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
					}
				}
				else
				{
					echo _theme_header($LANG_VARS['item_not_found']);
					echo _theme_error($LANG_VARS['item_not_found']);
				}
			}
			else if($HTTP_VARS['op'] == "my_history")
			{
				if(is_user_valid($HTTP_VARS['uid']) && $HTTP_VARS['uid']!==$HTTP_SESSION_VARS['user_id'] && is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
				{
					$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['uid']),'user_id'=>$HTTP_VARS['uid']), $LANG_VARS['borrower_history_for_fullname']);
					$total_items = fetch_my_history_item_cnt($HTTP_VARS['uid']);
					if($total_items>0)
					{
						$listingObject->setTotalItems($total_items);
						$listingObject->initListing($HTTP_VARS);
					
						$result = fetch_my_history_item_rs(
											$HTTP_VARS['uid'], 
											$HTTP_VARS['order_by'], 
											$HTTP_VARS['sortorder'], 
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
					}
				}
				else
				{
					$page_title = $LANG_VARS['my_history'];
					$total_items = fetch_my_history_item_cnt($HTTP_SESSION_VARS['user_id']);
					if($total_items>0)
					{
						$listingObject->setTotalItems($total_items);
						$listingObject->initListing($HTTP_VARS);
					
						$result = fetch_my_history_item_rs(
											$HTTP_SESSION_VARS['user_id'], 
											$HTTP_VARS['order_by'], 
											$HTTP_VARS['sortorder'], 
											$listingObject->getStartIndex(),
											$listingObject->getItemsPerPage());
					}
				}	
			}
			else if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && ($HTTP_VARS['op'] == "my_reserve_basket" || $HTTP_VARS['op'] == "update_my_reserve_basket" || $HTTP_VARS['op'] == "delete_from_my_reserve_basket"))
			{
				$page_title = str_replace(" ", "&nbsp;", $LANG_VARS['item_reserve_list']);
				
				$listingObject->setCheckBoxColumn('item_id_instance_no', TRUE);

				if($HTTP_VARS['op'] == "update_my_reserve_basket" || $HTTP_VARS['op'] == "delete_from_my_reserve_basket")
				{
					// We might be reserving a single item only - item_display.php would initiate this operation
					if(is_empty_array($HTTP_VARS['item_id_instance_no']) && is_numeric($HTTP_VARS['item_id']) && is_numeric($HTTP_VARS['instance_no']))
					{
						// Set it up so it looks as if an item was previously checked, but has now been unchecked! - called from item_display.php
						if($HTTP_VARS['op'] == "delete_from_my_reserve_basket")
						{
							if( is_array($HTTP_SESSION_VARS['reserve_basket_listing']) && ($key = array_search2($HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'], $HTTP_SESSION_VARS['reserve_basket_listing']))!==FALSE )
							{
								// Remove element
								array_splice($HTTP_SESSION_VARS['reserve_basket_listing'], $key, 1);
							}
							
						}
						else // else add item to session array. 
						{
							if( !is_array($HTTP_SESSION_VARS['reserve_basket_listing']) || !in_array($HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'], $HTTP_SESSION_VARS['reserve_basket_listing']) )
							{
								// Add element
								$HTTP_SESSION_VARS['reserve_basket_listing'][] = $HTTP_VARS['item_id']."_".$HTTP_VARS['instance_no'];
							}
						}
					}
					else if($HTTP_VARS['op'] == "update_my_reserve_basket" && (is_not_empty_array($HTTP_VARS['item_id_instance_no']) || strlen(trim($HTTP_VARS['checked_item_id_instance_no_list']))>0) ) // initiated from listings.php page!
					{
						// Now process checked items.
						$listingObject->setCheckedList(NULL, $HTTP_VARS);
						
						$HTTP_SESSION_VARS['reserve_basket_listing'] = 
													process_array(
															$HTTP_SESSION_VARS['reserve_basket_listing'], 
															$listingObject->getCheckedList());
						$listingObject->resetCheckedList();
					}
					else // Internal to borrow.php only!
					{
						// Now process checked items.
						$listingObject->setCheckedList(NULL, $HTTP_VARS);
						
						if($HTTP_VARS['op'] == "delete_from_my_reserve_basket")
						{
							$HTTP_SESSION_VARS['reserve_basket_listing'] = 
														minus_array_values(
																$HTTP_SESSION_VARS['reserve_basket_listing'], 
																$listingObject->getCheckedList());
							$listingObject->resetCheckedList();
						}
					}
						
					if(is_register_globals_enabled())
					{
						session_register("reserve_basket_listing");
						$reserve_basket_listing = $HTTP_SESSION_VARS['reserve_basket_listing'];
					}
					
					// Set it explicitly here.
					$HTTP_VARS['op'] = "my_reserve_basket";
				}
				else // if($HTTP_VARS['op'] == "my_reserve_basket")
				{
					$listingObject->setCheckedList(NULL, $HTTP_VARS);
				}

				// Get actual total
				$total_items = count($HTTP_SESSION_VARS['reserve_basket_listing']);
				$listingObject->setTotalItems($total_items);
				$listingObject->initListing($HTTP_VARS);
				
				//##################################################################
				// Sort Reserve Basket array according to arguments.
				// This may be a little inefficient, recreating the $item_r arrays
				// for each of the $item_id_and_instance_no strings each time,
				// but for now it will do!
				//##################################################################

				// First of all, get all the reservations converted to $item_r records, so we can sort them!
				if(is_array($HTTP_SESSION_VARS['reserve_basket_listing']))
				{
					while(list(,$item_id_and_instance_no) = each($HTTP_SESSION_VARS['reserve_basket_listing']))
					{
						if(strlen($item_id_and_instance_no)>0)
						{
							$item_id_and_instance_no_r = get_item_id_and_instance_no($item_id_and_instance_no);
							if(is_not_empty_array($item_id_and_instance_no_r))
								$item_reservation_rs[] = fetch_item_instance_r($item_id_and_instance_no_r['item_id'], $item_id_and_instance_no_r['instance_no']);
						}
					}
				}
				
				if(is_not_empty_array($item_reservation_rs))
				{
					sort_item_reservation_rs($item_reservation_rs, $HTTP_VARS['order_by'], $HTTP_VARS['sortorder']);

					// Now get the bit we actually want for this page.
					if($HTTP_VARS['mode'] != "printable")
					{
						$item_reservation_rs = array_slice(
										$item_reservation_rs, 
										$listingObject->getStartIndex(), 
										$listingObject->getItemsPerPage());
					}
					
					// Ensure we are at the start of the array.
					if(is_array($item_reservation_rs))
						reset($item_reservation_rs);
				}

				// Include a Back to Listing link
				// If a single item was specified and it exists, provide a back to item link here.
				if($HTTP_VARS['item_link'] === "y" && is_exists_item_instance($HTTP_VARS['item_id'],$HTTP_VARS['instance_no']))
				{
					$footer_links_r[] = array(url=>"item_display.php?item_id=".$HTTP_VARS['item_id']."&instance_no=".$HTTP_VARS['instance_no']."&listing_link=".$HTTP_VARS['listing_link'],text=>$LANG_VARS['back_to_item']);
				}
				if($HTTP_VARS['listing_link'] === "y" && is_not_empty_array($HTTP_SESSION_VARS['listing_url_vars']))
				{
					$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
				}
			}
			else if($HTTP_VARS['op'] == "admin_history")
			{   
				echo(_theme_header($LANG_VARS['borrower_history']));
				echo("<h2>".$LANG_VARS['borrower_history']."</h2>");
			
				echo("\n<table cellspacing=1 border=0>");
				echo("\n<form action=\"$PHP_SELF\" method=\"get\">");
				echo("\n<input type=\"hidden\" name=\"op\" value=\"my_history\">");

				$results = fetch_user_rs(get_borrower_user_types_r(), "fullname", "ASC");
				echo(format_field($LANG_VARS['borrower'], NULL, custom_select('uid', $results, '%fullname% (%user_id%)', 1, NULL, 'user_id')));
				echo("<tr><td colspan=2 align=left><br><input type=submit value=\"".$LANG_VARS['continue']."\"></td></tr>");
		
				echo("</form>");
				echo("</table>");
		
				$show_listings=FALSE;
			}
			else
			{
				echo(_theme_header($LANG_VARS['operation_not_available']));
				echo(_theme_error($LANG_VARS['operation_not_available']));

				$show_listings=FALSE;	
			}

			if($show_listings)
			{
				echo(_theme_header($page_title));

				if($HTTP_VARS['mode'] != "printable")
				{
					echo("<h2>".$page_title." ".$page_image."</h2>");

					if($CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE && $HTTP_VARS['op'] != "my_item_history")
					{
						$listingObject->addToggleControl(
							$LANG_VARS['show_item_image'], 
							'show_item_image', 
							ifempty($HTTP_VARS['show_item_image'], $CONFIG_VARS['listings.show_item_image']==TRUE?'Y':'N'));
					}
				}
				
				$listingObject->startListing($PHP_SELF, $HTTP_VARS);
				$listingObject->startHeaderRow();
				
				if($HTTP_VARS['op'] != "my_item_history")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['type'], "s_item_type");
					$listingObject->writeHeaderColumn($LANG_VARS['title'], "title");
				}
			
				if($HTTP_VARS['op'] == "my_reserve_basket" || $HTTP_VARS['op'] == "my_borrowed" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "my_history" || $HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "all_reserved")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['owner'], "owner");
				}
				
				if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "owner_borrowed" || $HTTP_VARS['op'] == "my_item_history" || ($CONFIG_VARS['borrow.include_borrower_column']!==FALSE && ($HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "all_reserved")))
				{
					$listingObject->writeHeaderColumn($LANG_VARS['borrower'], "borrower");
				}
				
				if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "all_reserved" || $HTTP_VARS['op'] == "my_item_history")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['status']);
				}
		
				if($HTTP_VARS['op'] == "my_history")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['return_date']);
					$listingObject->writeHeaderColumn($LANG_VARS['total_duration']);
				}
				else if($HTTP_VARS['op'] == "my_item_history")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['return_date']."&nbsp;/<br>".$LANG_VARS['due_date']);
					$listingObject->writeHeaderColumn($LANG_VARS['total_duration']."&nbsp;/<br>".$LANG_VARS['borrow_duration']);
				}
				else if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "all_reserved")
				{
					$listingObject->writeHeaderColumn($LANG_VARS['reserve_date']);
				}
			
				if($CONFIG_VARS['borrow.duration_support'])
				{
					if($HTTP_VARS['op'] == "my_history" || $HTTP_VARS['op'] == "my_item_history")
						$listingObject->writeHeaderColumn($LANG_VARS['overdue_duration']);
					else if($HTTP_VARS['op'] == "my_borrowed" || $HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "owner_borrowed")
						$listingObject->writeHeaderColumn($LANG_VARS['due_date']);
					else // reserved!
						$listingObject->writeHeaderColumn($LANG_VARS['borrow_duration']);
				}

				$listingObject->endHeaderRow();
				
				// If mysql resultset or static $item_reservation_rs array defined, we
				// can continue.
				if( ($result || is_not_empty_array($item_reservation_rs)) && $total_items>0)
				{
					while( ($borrowed_item_r = next_record($result, $item_reservation_rs)) !== FALSE)
					{
						// In the case of 'my_reserve_basket' operation, a record may have been
						// erroneously entered into the basket list.  If so the next_record(...)
						// call will return NULL.  This allows the generation to continue (test for FALSE!)
						// but this 'if', will avoid displaying the record if invalid.
						if($borrowed_item_r == NULL)
						{
							// Do next loop of while now!
							continue;
						}
						
						$listingObject->startRow();
						
						$status_type_r = fetch_status_type_r($borrowed_item_r['s_status_type']);

						// Checkbox!
						if($listingObject->isCheckBoxColumn())
						{
							if($HTTP_VARS['op'] == "my_reserve_basket" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "owner_borrowed")
							{
								if($HTTP_VARS['op'] == "my_reserve_basket")
								{
									$listingObject->writeColumn($borrowed_item_r['item_id']."_".$borrowed_item_r['instance_no']);
								}
								else
								{
									// Owner checkout.
									if($HTTP_VARS['op'] != "owner_reserved" || (($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') && !is_item_borrowed($borrowed_item_r['item_id'],$borrowed_item_r['instance_no'])))
										$listingObject->writeColumn($borrowed_item_r['sequence_number']);
									else
										$listingObject->writeColumn();
								}
							}
						}
						
						if($HTTP_VARS['op'] != "my_item_history")
						{
							// Type
							$listingObject->writeColumn(
								get_item_image($borrowed_item_r['s_item_type']));
							
							// Get title mask processed.
							$borrowed_item_r['title'] = expand_type_title_mask($borrowed_item_r['title'], $borrowed_item_r['s_item_type'], $borrowed_item_r['item_id'], $borrowed_item_r['instance_no'], $borrowed_item_r['s_status_type'], $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);

							if($HTTP_VARS['mode'] != "printable")
								$borrowed_item_r['title'] = "<a href=\"item_display.php?item_id=".$borrowed_item_r['item_id']."&instance_no=".$borrowed_item_r['instance_no']."\">".$borrowed_item_r['title']."</a>";
							else
								$borrowed_item_r['title'] = $borrowed_item_r['title'];
							
							$append_to_title = "";
							
							// show star if rated
							if(is_item_reviewed($borrowed_item_r['item_id'], $borrowed_item_r['instance_no']))
							{
								// show star if rated - Add it to the actual title, so we can do a bit more with title masks
								$append_to_title .= _theme_image("rs.gif", NULL, $LANG_VARS['item_reviewed']);
							}
							
							if(($CONFIG_VARS['listings.allow_override_show_item_image']===FALSE && $CONFIG_VARS['listings.show_item_image']!==FALSE) ||
										$CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE && (($CONFIG_VARS['listings.show_item_image']!==FALSE && strlen($HTTP_VARS['show_item_image'])==0) || $HTTP_VARS['show_item_image'] == 'Y'))
							{
								$listingObject->writeColumn(
									"<table width=100% border=0 cellpadding=0 cellspacing=0><tr><td width=10% class=\"".$listingObject->getRowCSSClass()."\">".
									get_item_cover_image($borrowed_item_r['item_id'],$borrowed_item_r['s_item_type'], $item_type_rs).
									"</td>".
									"<td align=\"center\" class=\"".$listingObject->getRowCSSClass()."\">".
									$borrowed_item_r['title'].
							    	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
									"</td></tr></table>");
							}	
							else
							{
								$listingObject->writeColumn(
									$borrowed_item_r['title'].
							    	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:""));
							}
						}
					
						// Owner/Borrower
						if($HTTP_VARS['op'] == "my_reserve_basket" || $HTTP_VARS['op'] == "my_borrowed" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "my_history" || $HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "all_reserved")
						{
							$listingObject->writeColumn(
								get_list_username($borrowed_item_r['owner_id'], $HTTP_VARS['mode'], $CONFIG_VARS['borrow.owner_email_link'], $LANG_VARS['back_to_listing'], $PHP_SELF."?".get_url_string($HTTP_VARS)));
						}
						
						if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "owner_borrowed" || $HTTP_VARS['op'] == "my_item_history" || ($CONFIG_VARS['borrow.include_borrower_column']!==FALSE && ($HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "all_reserved")))
						{
							$listingObject->writeColumn(
								get_list_username($borrowed_item_r['borrower_id'], $HTTP_VARS['mode'], $CONFIG_VARS['borrow.borrower_email_link'], $LANG_VARS['back_to_listing'], $PHP_SELF."?".get_url_string($HTTP_VARS)));
						}
				
						// Checked Out status!
						if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "all_reserved")
						{
							if(is_item_borrowed($borrowed_item_r['item_id'],$borrowed_item_r['instance_no']))
								$listingObject->writeColumn(_theme_image("borrowed.gif", $LANG_VARS['borrowed'], NULL, NULL, "borrowed_item"));
							else if($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') // Reserved - If the items are here they have to have been reserved!
								$listingObject->writeColumn(_theme_image("reserved.gif", $LANG_VARS['reserved'], NULL, NULL, "borrowed_item"));
							else
								$listingObject->writeColumn(_theme_image($status_type_r['img'], $status_type_r['description'], NULL, NULL, "borrowed_item"));
						}
						else if($HTTP_VARS['op'] == "my_item_history")
						{
							if($borrowed_item_r['status'] == 'X')
								$listingObject->writeColumn(str_replace(" ", "&nbsp;", $LANG_VARS['cancelled']));
							else if($borrowed_item_r['status'] == 'R')
								$listingObject->writeColumn(str_replace(" ", "&nbsp;", $LANG_VARS['reserved']));
							else if($borrowed_item_r['status'] == 'C')
								$listingObject->writeColumn(str_replace(" ", "&nbsp;", $LANG_VARS['checked_in']));
							else if($borrowed_item_r['status'] == 'B')
								$listingObject->writeColumn(str_replace(" ", "&nbsp;", $LANG_VARS['checked_out']));
						}
						
						// Due Date / Borrow Duration / (Returned & Total Days & Overdue Days)
						if($HTTP_VARS['op'] == "my_history" || $HTTP_VARS['op'] == "my_item_history")
						{
							// Returned / Due Date
							if($borrowed_item_r['status'] == 'C' && strlen($borrowed_item_r['return_date'])>0)
								$listingObject->writeColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'],$borrowed_item_r['return_date']));
							else if($borrowed_item_r['status'] == 'X')
							{
								if($HTTP_VARS['op'] == "my_item_history")
									$listingObject->writeColumn($LANG_VARS['not_applicable']);
								else
									$listingObject->writeColumn($LANG_VARS['reservation_cancelled']);
							}
							else if($borrowed_item_r['status'] == 'B')
							{
								if($CONFIG_VARS['borrow.duration_support'] && strlen($borrowed_item_r['due_date'])>0)
									$listingObject->writeColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $borrowed_item_r['due_date']));
								else
									$listingObject->writeColumn($LANG_VARS['undefined']);
							}
							else if($borrowed_item_r['status'] == 'R')
								$listingObject->writeColumn($LANG_VARS['not_applicable']);
							else
								$listingObject->writeColumn();

							// Total Duration / Borrow Duration
							if($borrowed_item_r['status'] == 'C' && is_numeric($borrowed_item_r['total_duration']))
								$listingObject->writeColumn($borrowed_item_r['total_duration']);
							else if($borrowed_item_r['status'] == 'X')
								$listingObject->writeColumn($LANG_VARS['not_applicable']);
							else if($borrowed_item_r['status'] == 'B' && is_numeric($borrowed_item_r['calc_total_duration']))
								$listingObject->writeColumn($borrowed_item_r['calc_total_duration']);
							else if($borrowed_item_r['status'] == 'R' && is_numeric($borrowed_item_r['ii_borrow_duration']) && $borrowed_item_r['ii_borrow_duration']>0)
							{
								$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($borrowed_item_r['s_item_type'], 'DURATION', TRUE);
								$listingObject->writeColumn(
										get_display_field($duration_attr_type_r['s_attribute_type'], NULL, $duration_attr_type_r['display_type'], $borrowed_item_r['ii_borrow_duration'], FALSE));
							}
							else
								$listingObject->writeColumn($LANG_VARS['unknown']);
						}
			
						if($HTTP_VARS['op'] == "owner_reserved" || $HTTP_VARS['op'] == "my_reserved" || $HTTP_VARS['op'] == "all_reserved")
						{
							$listingObject->writeColumn(get_localised_timestamp($CONFIG_VARS['borrow.datetime_mask'], $borrowed_item_r['update_on']));
						}
				
						if ($CONFIG_VARS['borrow.duration_support'])
						{
							if($HTTP_VARS['op'] == "my_history" || $HTTP_VARS['op'] == "my_item_history")
							{
								// Overdue Days
								if($borrowed_item_r['status'] == 'X')
									$listingObject->writeColumn($LANG_VARS['not_applicable']);
								else if($borrowed_item_r['status'] == 'C' || $borrowed_item_r['status'] == 'B')
								{
									if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0 && is_numeric($borrowed_item_r['total_duration']))
									{
										if($borrowed_item_r['total_duration'] > $borrowed_item_r['borrow_duration'])
											$listingObject->writeColumn($borrowed_item_r['total_duration'] - $borrowed_item_r['borrow_duration']);
										else
											$listingObject->writeColumn("0");
									}
									else if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0 && is_numeric($borrowed_item_r['calc_total_duration']))
									{
										if($borrowed_item_r['calc_total_duration'] > $borrowed_item_r['borrow_duration'])
											$listingObject->writeColumn($borrowed_item_r['calc_total_duration'] - $borrowed_item_r['borrow_duration']);
										else
											$listingObject->writeColumn("0");
									}
									else
										$listingObject->writeColumn($LANG_VARS['unknown']);
								}
								else // reserved - item_history
									$listingObject->writeColumn($LANG_VARS['not_applicable']);								
							}
							else if($HTTP_VARS['op'] == "my_borrowed" || $HTTP_VARS['op'] == "all_borrowed" || $HTTP_VARS['op'] == "owner_borrowed")
							{
								if(strlen($borrowed_item_r['due_date'])>0)
									$listingObject->writeColumn(get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $borrowed_item_r['due_date']));
								else
									$listingObject->writeColumn($LANG_VARS['undefined']);
							}
							else // Reserved
							{
								if(is_numeric($borrowed_item_r['borrow_duration']) && $borrowed_item_r['borrow_duration']>0)
								{
									$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($borrowed_item_r['s_item_type'], 'DURATION', TRUE);
									$listingObject->writeColumn(
											get_display_field($duration_attr_type_r['s_attribute_type'], NULL, $duration_attr_type_r['display_type'], $borrowed_item_r['borrow_duration'], FALSE));
								}
								else
									$listingObject->writeColumn($LANG_VARS['undefined']);
							}
						}
						$listingObject->endRow();
					}// End of while
	
					// Free result if mysql resultset
					if(isset($result) && !is_array($result))
						@mysql_free_result($result);

					// ----------------------------------------------------------
					if($HTTP_VARS['mode'] != "printable")
					{
						if($HTTP_VARS['op'] == "my_reserve_basket")
						{
							$listingObject->addListOpAction($LANG_VARS['delete_from_reserve_list'], '', 'delete_from_my_reserve_basket');
							$listingObject->addListOpAction($LANG_VARS['reserve_item(s)'], 'item_borrow.php', 'reserve');
							$listingObject->addListOpAction($LANG_VARS['reserve_all_item(s)'], 'item_borrow.php', 'reserve_all', FALSE);
						}
						else if($HTTP_VARS['op'] == "my_reserved")
						{
							$listingObject->addListOpAction($LANG_VARS['cancel_reservation(s)'], 'item_borrow.php', 'cancel_reserve');
						}
						else if($HTTP_VARS['op'] == "owner_borrowed")
						{
							$listingObject->addListOpAction($LANG_VARS['check_in_item(s)'], 'item_borrow.php', 'check_in');
							$listingObject->addListOpAction($LANG_VARS['send_reminder(s)'], 'item_borrow.php', 'reminder');
								
							if($CONFIG_VARS['borrow.duration_support']!==FALSE)
							{
								$listingObject->addListOpAction($LANG_VARS['borrow_duration_extension(s)'], 'item_borrow.php', 'extension');
							}
						}
						else if($HTTP_VARS['op'] == "owner_reserved")
						{
							$listingObject->addListOpAction($LANG_VARS['check_out_item(s)'], 'item_borrow.php', 'check_out');
							$listingObject->addListOpAction($LANG_VARS['cancel_reservation(s)'], 'item_borrow.php', 'cancel_reserve');
						}
					}
				}//if( ($result || is_not_empty_array($item_reservation_rs)) && $total_items>0)
				$listingObject->endListing();
				
				$help_entries_rs[] = array('img'=>'rs.gif', 'text'=>$LANG_VARS['item_reviewed']);

				// This is a read only page, so no help required.
				if($HTTP_VARS['mode'] != "printable")
				{
					if($total_items>0)
						$help_entries_rs[] = replace_lang_var("total", $listingObject->getTotalItemCount(), $LANG_VARS['printable_version_notes']);
						
					if($HTTP_VARS['op'] != "my_history" && $HTTP_VARS['op'] != "admin_history")
					{
						while (list(,$help) = @each($LANG_VARS['borrow_help']))
							$help_entries_rs[] = $help;
					}
					if($HTTP_VARS['op'] == "my_item_history")
					{
						while (list(,$help) = @each($LANG_VARS['borrow_item_history_help']))
							$help_entries_rs[] = $help;
					}
					if($HTTP_VARS['op'] == "my_reserve_basket")
					{
						while (list(,$help) = @each($LANG_VARS['reserve_basket_help']))
							$help_entries_rs[] = $help;
					}
				}
				
				if($CONFIG_VARS['listings.title_mask_macro_theme_img_help']!==FALSE)
				{
					$title_mask_elements = get_title_mask_macro_element_r('theme_img');
					if(is_array($title_mask_elements))
					{
						while(list($img,$prompt) = each($title_mask_elements))
							$help_entries_rs[] = array('img'=>$img, 'text'=>$prompt);
					}
				}
				echo(format_help_block($help_entries_rs));
				
				if($HTTP_VARS['mode'] != "printable" && $listingObject->getTotalItemCount() > 0)
				{
					$HTTP_SESSION_VARS['listing_url_vars']['item_id_instance_no'] = NULL;
					$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no'] = NULL;
					$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no_list'] = NULL;
				
					echo("\n<p align=center class=\"footer\"><i><a href=\"$PHP_SELF?".
						get_url_string(
							$HTTP_VARS, 
							array('mode'=>'printable'), 
							array( //exclude
								'page_no',
								'listing_link')).
						"\" target=_blank>"._theme_image("printable.gif", "", NULL, "absmiddle").$LANG_VARS['printable_version']."</a></i></p>");
				}
			}//end if($show_listings)		
		}//no guests allowed!
		else
		{
			echo(_theme_header($LANG_VARS['not_authorized_to_page']));
			echo(_theme_error($LANG_VARS['not_authorized_to_page']));
		}
	}//borrow functionality disabled.
	else
	{
		echo(_theme_header($LANG_VARS['borrow_not_supported']));
		echo(_theme_error($LANG_VARS['borrow_not_supported']));
	}
	
	if($HTTP_VARS['mode'] != "printable")
	{
		echo(format_footer_links($footer_links_r));
	}
	echo(_theme_footer());
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
