<?php
/* 	
	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/datetime.php");

/**
	Notice that $include_menu is ignored, and no menu is
	ever displayed.
*/
function theme_header($title, $include_menu)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	global $CONFIG_VARS;
	
	echo("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">".
		"\n<html>".
		"\n<head>".
		"\n	<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version'].(!empty($title)?" - $title":"")."</title>".
		"\n	<link rel=\"stylesheet\" type=\"text/css\" href=\"theme/$_OPENDB_THEME/style.css\">".
		"\n</head>".
		"\n<body>");

	// Notice the hardcoded image here!
	$today = get_localised_timestamp($CONFIG_VARS['print_listing.datetime_mask']);
	echo("<p align=center><font class=\"printtitle\"><img src=\"images/icon.gif\" alt=\"".$CONFIG_VARS['site.title']."\" align=bottom border=0>&nbsp;".$CONFIG_VARS['site.title']." - <i>$title</i></font><br>$today</p>");
}

/**
*/
function theme_footer()
{
	echo("\n</body>".
		"\n</html>");
}

/**
	For 'Printable' theme, we will display the $alt text for the status
	images only.  All the other images can be displayed as normal.
*/
function theme_image($src, $alt, $title, $align, $type, $class, $width, $height)
{
	if($type == "borrowed_item")
		return "<i>$alt</i>";
	else // Let the standard '_theme_image' functionality generate the image otherwise.
		return FALSE;
}

/**
	Displays an error page.
*/
function theme_error($error)
{
	echo("\n<div class=\"error\">$error</div>");
}
?>
