<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

function update_order_no($item_id, $s_attribute_type, $new_order_no, $old_order_no)
{
	$query = "UPDATE item_attribute set order_no = $new_order_no ".
			 "WHERE item_id = '$item_id' AND s_attribute_type = '".$s_attribute_type."' AND ".
			" order_no = '$old_order_no'";
	$update = run_opendb_query($query, FALSE);
	if ($update)
		return mysql_affected_rows();
	else
		return FALSE;
}

function fetch_order_no($s_item_type, $s_attribute_type)
{
	$query = "SELECT order_no from s_item_attribute_type ".
			 "WHERE s_item_type = '$s_item_type' AND s_attribute_type = '".$s_attribute_type."'";
	$result = run_opendb_query($query, FALSE);
	if($result && mysql_num_rows($result)>0){
		$found = mysql_fetch_array($result);
		mysql_free_result($result);
		return $found['order_no'];
	}
	else
		return FALSE;	
}

//local copy of function.
function my_insert_item_instance($item_id, $owner_id, $active_ind, $update_on)
{
	// Ensure we have a valid active_ind value.
	if($active_ind != 'y' && $active_ind != 'Y')
		$active_ind = 'N';
		
	$query = "INSERT INTO item_instance(item_id, instance_no, owner_id, active_ind, update_on)".
				"VALUES ('$item_id','1','$owner_id',UPPER('".$active_ind."'), '$update_on')";

	$insert = run_opendb_query($query, FALSE);
	if ($insert && mysql_affected_rows() > 0){
		return TRUE;
	}else{
		return FALSE;
	}
}

/**
	Will check if reviews already been populated.  If a review is for the same item,
	has the same author and is for the same date exactly, then we assume it is a 
	duplicate, too bad if it is not!
*/
function is_exists_review($item_id, $author_id, $update_on)
{
	$query = "select 'x' from review where item_id = '$item_id' AND ".
				"author_id = '$author_id' AND update_on = '$update_on'";
	$result = run_opendb_query($query, FALSE);
	if($result && mysql_num_rows($result)>0)
		return TRUE;
	else
		return FALSE;
}

//
// Insert a comment
//
function my_insert_review($item_id, $author_id, $comment, $rating, $update_on)
{
	$query="INSERT INTO review (item_id,author_id,comment,rating,update_on)".
			"VALUES ('$item_id','".$author_id."','".addslashes($comment)."','".$rating."','".$update_on."')";
	$insert = run_opendb_query($query, FALSE);
	if ($insert && mysql_affected_rows() > 0)
	{
		return TRUE;
	}else{
		return FALSE;
	}
}
function update_items()
{
	echo ("<p class=\"querytitle\">Update Item Instance table</p>");
	
	$query = "select i.id, i.title, i.owner_id, i.active_ind, i.update_on from item i where i.s_item_type like '%' and i.parent_id IS NULL group by 1";
	$result = run_opendb_query($query, FALSE);
	while($item_r = mysql_fetch_array($result))
	{
		if(my_insert_item_instance($item_r['id'], $item_r['owner_id'], $item_r['active_ind'], $item_r['update_on']))
			echo "<div class=\"upgrade_success\">Item instance for \"".$item_r['title']."\" (item_id=".$item_r['id'].") inserted...</div>";
		else
			echo "<div class=\"upgrade_failure\">Item instance for \"".$item_r['title']."\" (item_id=".$item_r['id'].") NOT inserted...</div>";
		echo("<br>");
	}
}

/**
	If there is more than one item with the same title, we will have to insert duplicate reviews as
	part of the patch.
*/
function update_reviews()
{
	echo ("<p class=\"querytitle\">Update Review table</p>");
	$query = "SELECT 'x' FROM review_old";
	$check = run_opendb_query($query, FALSE);
	if(!$check)
	{
		echo "Error: ".mysql_error();
		echo "<p>Please ensure that you have successfully completed the previous steps first.";
	}
	else
	{
		$query = "select r.title, r.s_item_type, r.author_id, r.comment, r.rating, r.update_on from review_old r order by 1";
		$result = run_opendb_query($query, FALSE);
		while($review_r = mysql_fetch_array($result))
		{
			$query2 = "select i.id from item i where i.title = '".$review_r['title']."' AND i.s_item_type = '".$review_r['s_item_type']."'"; 
			$result2 = run_opendb_query($query2, FALSE);
			while($item_r = mysql_fetch_array($result2))
			{
				if(!is_exists_review($item_r['id'], $review_r['author_id'], $review_r['update_on']) && 
						my_insert_review($item_r['id'], $review_r['author_id'], $review_r['comment'], $review_r['rating'], $review_r['update_on']))
					echo "<div class=\"upgrade_success\">Review for \"".$review_r['title']."\" (item_id=".$item_r['id'].", author=".$review_r['author_id'].", s_item_type=".$review_r['s_item_type'].") inserted...</div>";
				else
					echo "<div class=\"upgrade_failure\">Review for \"".$review_r['title']."\" (item_id=".$item_r['id'].", author=".$review_r['author_id'].", s_item_type=".$review_r['s_item_type'].") NOT inserted...</div>";
				echo("<br>");
			}
		}
	}
}

function update_item_attributes()
{
	echo ("<p class=\"querytitle\">Update Item Attribute table</p>");
	
	// Need to temporarily remove primary key constraint so we can update table.
	echo "<p><b>Removing item_attribute Primary Key while we update...</b></p>";
	$query = "ALTER TABLE item_attribute DROP PRIMARY KEY";
	$update = run_opendb_query($query, FALSE);
	if($update && mysql_affected_rows()>0){
		$query = "select i.id, i.title, i.s_item_type from item i order by i.id";
		$items = run_opendb_query($query, FALSE);
		while($item_r = mysql_fetch_array($items))
		{
			$failed=0;
			$updated=0;
			$ignored=0;
			
			$query2 = "select ia.s_attribute_type, ia.order_no from item_attribute ia where ia.item_id = '".$item_r['id']."' order by ia.s_attribute_type";
			$attrs = run_opendb_query($query2, FALSE);
			while($attrs_r = mysql_fetch_array($attrs))
			{
				if($attrs_r['s_attribute_type']!='CDTRACK')
					$new_order_no = fetch_order_no($item_r['s_item_type'], $attrs_r['s_attribute_type']);
				else {//CDTRACK
					if( ((int)$attrs_r['order_no'])<46)
						$new_order_no = ((int)$attrs_r['order_no']) + 46;// This is the difference
					else// Set it to the same value so that it is ignored.
						$new_order_no = $attrs_r['order_no'];						
				}
			
				if($new_order_no === $attrs_r['order_no'])
					$ignored++;
				else
				{					
					$count = update_order_no($item_r['id'], $attrs_r['s_attribute_type'], $new_order_no, $attrs_r['order_no']);
					if($count!==FALSE && $count==0)
						$ignored++;
					else if($count!==FALSE && $count>0)
						$updated++;
					else
						$failed++;
				}						
			}

			// Work out what format the status should be.
			if($failed>0){
				echo("<div class=\"upgrade_failure\">Updating \"".$item_r['title']."\" (item_id=".$item_r['id'].")");
				echo(" [Ignored=$ignored, Updated=$updated, Failed=$failed]</div><br>");
			}else{
				echo("<div class=\"upgrade_success\">Updating \"".$item_r['title']."\" (item_id=".$item_r['id'].")");
				echo(" [Ignored=$ignored, Updated=$updated]</div><br>");
			}
		}

		echo "<p><b>Restoring item_attribute Primary Key...</b></p>";
		$query = "ALTER TABLE item_attribute DROP PRIMARY KEY, ADD PRIMARY KEY (item_id,s_attribute_type,order_no)";
		$update = run_opendb_query($query, FALSE);
		if(!$update || mysql_affected_rows()<=0){
			echo ("<div class=\"error\">Primary key was not restored to item_attribute table (".mysql_error().")</div>"); 
		}
	}else{
		echo("<div class=\"error\">Primary key was not disabled for item_attribute table (".mysql_error().")"); 
		echo("<br><i>Ensure that your default database user has ALTER TABLE priveleges...</i></div>");
	}
	return TRUE;
}

// This is important for security reasons.
if($CONFIG_VARS['patch.enable']===TRUE)
{
	session_register("step_completed");

	// Provide this variable to all patches.
	if(!isset($HTTP_SESSION_VARS['step_completed']))
	{
		$step_completed=0;
	}

	if ($HTTP_VARS['op'] == "menu")
	{
	?>

		<DIV ALIGN="CENTER">
		<FORM action="<?php echo $PHP_SELF; ?>" method="get" target="main">
		<?php print_button("step1", "1. Execute patch_before.sql", isset($HTTP_SESSION_VARS['step_completed']) && $HTTP_SESSION_VARS['step_completed']>=1); ?>
		<?php print_button("step2", "2. Update Item Attribute table", isset($HTTP_SESSION_VARS['step_completed']) && ($HTTP_SESSION_VARS['step_completed']>=2 || $HTTP_SESSION_VARS['step_completed']<1)); ?>
		<?php print_button("step3", "3. Insert Item Instance records", isset($HTTP_SESSION_VARS['step_completed']) && ($HTTP_SESSION_VARS['step_completed']>=3 || $HTTP_SESSION_VARS['step_completed']<2)); ?>
		<?php print_button("step4", "4. Update Review table", isset($HTTP_SESSION_VARS['step_completed']) && ($HTTP_SESSION_VARS['step_completed']>=4 || $HTTP_SESSION_VARS['step_completed']<3)); ?>
		<?php print_button("step5", "5. Execute patch_after.sql", isset($HTTP_SESSION_VARS['step_completed']) && ($HTTP_SESSION_VARS['step_completed']>=5 || $HTTP_SESSION_VARS['step_completed']<4)); ?>
		<INPUT TYPE="hidden" name="op" value="result">
		<INPUT TYPE="hidden" name="from" value="<?php echo $HTTP_VARS['from']; ?>">
		</FORM>
		</DIV>
	 <?php
		echo("<p class=\"colortext\">This patch will be accomplished in series of separate steps.  Once you have performed one step
			the script will move to the next.  This script will only know about an execution of a particular step
			while your current session is active.  If you try to execute this patch script at a later time, it will
			proceed, and most probably wipe out your data, or at least corrupt it!</b></p>");
	}
	else // Do the work
	{
		if(isset($HTTP_VARS['step1']) && $HTTP_SESSION_VARS['step_completed']<1)
		{
			$step_completed = 1;
			exec_sql_file($HTTP_VARS['from'], "patch_before.sql", FALSE);
		}
		else if(isset($HTTP_VARS['step2']) && $HTTP_SESSION_VARS['step_completed']<2)
		{
			$step_completed = 2;
			update_item_attributes();
		}
		else if(isset($HTTP_VARS['step3']) && $HTTP_SESSION_VARS['step_completed']<3)
		{
			$step_completed = 3;
			update_items();
		}
		else if(isset($HTTP_VARS['step4']) && $HTTP_SESSION_VARS['step_completed']<4)
		{
			$step_completed = 4;
			update_reviews();
		}
		else if(isset($HTTP_VARS['step5']) && $HTTP_SESSION_VARS['step_completed']<5)
		{
			$step_completed = 5;
			exec_sql_file($HTTP_VARS['from'], "patch_after.sql", FALSE);
		}
		else if(isset($HTTP_VARS['stepx']))//for devel only.
		{
			echo ("<p class=\"querytitle\">Script reset</p>");
			$step_completed = 0;
		}
	}
	
	$HTTP_SESSION_VARS['step_completed'] = $step_completed;
}
?>
