/* $Id: nws_memory.h,v 1.17 2004/03/26 07:15:58 graziano Exp $ */

#ifndef MEMORY_H
#define MEMORY_H


#include <stddef.h>      /* offsetof() */
#include "formatutil.h"  /* DataDescriptor */
#include "nws_messages.h"    /* Message number ranges */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * A structure that describes a stored state (basically, a file).  #id# is the
 * client-supplied unique identifier for the state.  #rec_size# is the length
 * of each record in the state (state files have fixed-length records).
 * #rec_count# is the number of records that accompanies the state record in the
 * {FETCH,STORE}_STATE message, *not* the total number of records in the file
 * (the latter is determined by nws_memory).  #seq_no# is a time-stamp
 * indicating the time that the state records were generated, #time_out# the
 * number of seconds that they should be held before being discarded.
 */
#define STATE_NAME_SIZE (127 + 1)
struct nws_memory_state {
	char id[STATE_NAME_SIZE];
	int rec_size;
	int rec_count;
	double seq_no;
	double time_out;
};
static const DataDescriptor stateDescriptor[] =
  {SIMPLE_MEMBER(CHAR_TYPE, STATE_NAME_SIZE, offsetof(struct nws_memory_state, id)),
   SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct nws_memory_state, rec_size)),
   SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct nws_memory_state, rec_count)),
   SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(struct nws_memory_state, seq_no)),
   SIMPLE_MEMBER(DOUBLE_TYPE, 1, offsetof(struct nws_memory_state, time_out))};
#define stateDescriptorLength 5

/* as of Version 2.8.2 there is a new message STORE_AND_REGISTER that
 * extends the STORE_STATE in which the client gives a full registration
 * instead of the series name. The registration is piggyback on the
 * experiments, here we store only the size in id_len. This structure is
 * used only in STORE_AND_REGISTER messages. The FECTH will still returns
 * the nws_memory_state */
struct nws_memory_new_state {
	int id_len;
	int rec_size;
	int rec_count;
	unsigned long seq_no;
	unsigned long time_out;
};
static const DataDescriptor newStateDescriptor[] =
  {SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct nws_memory_new_state, id_len)),
   SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct nws_memory_new_state, rec_size)),
   SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct nws_memory_new_state, rec_count)),
   SIMPLE_MEMBER(UNSIGNED_LONG_TYPE, 1, offsetof(struct nws_memory_new_state, seq_no)),
   SIMPLE_MEMBER(UNSIGNED_LONG_TYPE, 1, offsetof(struct nws_memory_new_state, time_out))};
#define newStateDescriptorLength 5

#define LOCATION_NAME_SIZE 128

typedef enum {MEMORY_LOG_NONE, MEMORY_LOG_LOCAL, MEMORY_LOG_NETLOGGER,
			  MEMORY_LOG_REMOTE} MemLogDest;

struct loglocation {
  int loc_type; /* MEMORY_LOGLOCATION message types */
  char path[LOCATION_NAME_SIZE]; /* dir, host:port, host:dir */
};

const static DataDescriptor loglocationDescriptor[] =
  {SIMPLE_MEMBER(INT_TYPE, 1, offsetof(struct loglocation, loc_type)),
  SIMPLE_MEMBER(CHAR_TYPE, LOCATION_NAME_SIZE,
				offsetof(struct loglocation, path))};

#define loglocationDescriptorLength 2

#ifdef __cplusplus
}
#endif

#endif
