/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <string.h>
#include "prototypes.h"

recent_list rl;

void init_recent_list(recent_list * rl)
{
    rl->no_of_entries = 0;
}

void send_recent_list()
{
    int i;
    ntheader header;
    netrecentadvert advert;
    struct timeval t;

    debug("** Recent list transmitting\n");
    init_header(&header, RECENT_ADVERT);

    get_cur_time(&t);
    for (i = 0; i < rl.no_of_entries; i++) {

#ifdef PARANOIA
	ENTRY *item, searchitem;
	searchitem.key = rl.entries[i].id;
	item = hsearch(searchitem, FIND);
	l = (line *) (item->data);
	if (l->type == LINEMSG)
	    if (newer(&(rl.entries[i].last_mod), &(l->last_mod))) {
		printf("Got a bug in my recent list code\n");
#ifdef ABORT
		abort();
#endif
	    }
#endif				/* PARANOIA */
	htonid(rl.entries[i].id, &(advert.entries[i].id));
	htontime(&(rl.entries[i].last_mod), &(advert.entries[i].last_mod));
	advert.entries[i].type = rl.entries[i].type;
    }
    advert.no_of_entries = htonl(rl.no_of_entries);
    xsocksend(&header, (u_char *) & advert,
	      sizeof(int) + rl.no_of_entries * sizeof(netrecentitem));
}

void add_to_recent_list(char *id, struct timeval *t, int type)
{
    int oldest;
#ifdef PARANOIA
    ENTRY *item, searchitem;
    line *l;
#endif				/* PARANOIA */
    if (is_in_recent_list(id) == FALSE) {
	if (rl.no_of_entries < MAX_NUMBER_RECENT) {
	    oldest = rl.no_of_entries;
	    rl.no_of_entries++;
	} else {
	    oldest = find_oldest_recent_entry();
	}
	strncpy(rl.entries[oldest].id, id, ID_LEN);
	rl.entries[oldest].type = type;
	time_copy(t, &(rl.entries[oldest].last_mod));
#ifdef PARANOIA
	searchitem.key = rl.entries[oldest].id;
	item = hsearch(searchitem, FIND);
	if (item == NULL) {
	    debug("null pointer in recent list code 1\n");
	}
	l = (line *) (item->data);
	if (l->type == LINEMSG)
	    if (newer(&(rl.entries[oldest].last_mod), &(l->last_mod))) {
		printf("Got a bug in my recent list code\n");
#ifdef ABORT
		abort();
#endif
	    }
#endif				/* PARANOIA */
    } else {
	oldest = posn_in_recent_list(id);
	time_copy(t, &(rl.entries[oldest].last_mod));
#ifdef PARANOIA
	searchitem.key = rl.entries[oldest].id;
	item = hsearch(searchitem, FIND);
	if (item == NULL) {
	    debug("null pointer in recent list code 2\n");
	}
	l = (line *) (item->data);
	if (l->type == LINEMSG)
	    if (newer(&(rl.entries[oldest].last_mod), &(l->last_mod))) {
		printf("Got a bug in my recent list code\n");
#ifdef ABORT
		abort();
#endif
	    }
#endif				/* PARANOIA */
    }
}

int is_in_recent_list(char *id)
{
    int i;
#ifdef NOTDEF
    static char cacheid[ID_LEN];
    if (strncmp(cacheid, id, ID_LEN) == 0)
	return TRUE;
#endif
    for (i = 0; i < rl.no_of_entries; i++) {
	if (strncmp(rl.entries[i].id, id, ID_LEN) == 0) {
#ifdef NOTDEF
	    strncpy(cacheid, id, ID_LEN);
#endif
	    return TRUE;
	}
    }
    return FALSE;
}

int posn_in_recent_list(char *id)
{
    int i;
#ifdef NOTDEF
    static char cacheid[ID_LEN];
    static int cachenum;
    printf("%s - %s\n", cacheid, id);
    if (strncmp(cacheid, id, ID_LEN) == 0) {
	printf("cache hit\n");
	return cachenum;
    }
#endif
    for (i = 0; i < rl.no_of_entries; i++) {
	if (strncmp(rl.entries[i].id, id, ID_LEN) == 0) {
#ifdef NOTDEF
	    strncpy(cacheid, id, ID_LEN);
	    cachenum = i;
#endif
	    return i;
	}
    }
    return -1;
}

int find_oldest_recent_entry()
{
    int i, num = 0;
    long secs = rl.entries[0].last_mod.tv_sec;
    for (i = 0; i < rl.no_of_entries; i++) {
	if (rl.entries[i].last_mod.tv_sec < secs) {
	    num = i;
	    secs = rl.entries[i].last_mod.tv_sec;
	}
    }
    return num;
}
