/* an input pathname ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
pathname_edit_ok( iWindow *iwnd, 
	void *client, iWindowNotifyFn nfn, void *sys )
{
	Filesel *filesel = FILESEL( iwnd );
	Pathname *pathname = PATHNAME( client );
	char *fname;

	if( (fname = filesel_get_filename( filesel )) ) {
		SETSTR( pathname->value, fname );
		classmodel_update( CLASSMODEL( pathname ) );
		symbol_recalculate_all();

		g_free( fname );

		nfn( sys, IWINDOW_TRUE );
	}
	else
		nfn( sys, IWINDOW_ERROR );
}

/* Pop up a pathname edit box.
 */
static void 
pathname_edit( GtkWidget *parent, Model *model )
{
	Pathname *pathname = PATHNAME( model );
	GtkWidget *filesel = filesel_new();

	iwindow_set_title( IWINDOW( filesel ), IOBJECT( model )->caption );
	filesel_set_flags( FILESEL( filesel ), TRUE, FALSE );
	filesel_set_filetype( FILESEL( filesel ), filesel_type_any, 0 );
	idialog_set_parent( IDIALOG( filesel ), parent );
	idialog_set_iobject( IDIALOG( filesel ), IOBJECT( model ) );
	filesel_set_done( FILESEL( filesel ), pathname_edit_ok, pathname );
	iwindow_build( IWINDOW( filesel ) );
	filesel_set_filename( FILESEL( filesel ), pathname->value );

	gtk_widget_show( GTK_WIDGET( filesel ) );
}

static xmlNode *
pathname_save( Model *model, xmlNode *xnode )
{
	Pathname *pathname = PATHNAME( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "value", "%s", pathname->value ) )
			return( NULL );
	}

	return( xthis );
}

static gboolean
pathname_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Pathname *pathname = PATHNAME( model );
	char buf[MAX_STRSIZE];

	assert( IS_RHS( parent ) );

	if( get_sprop( xnode, "value", buf, MAX_STRSIZE ) ) {
		classmodel_set_edited( CLASSMODEL( model ), TRUE );
		SETSTR( pathname->value, buf );
	}

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Pathname from heap.
 */
static gboolean
pathname_class_get( Classmodel *classmodel, PElement *root )
{
	Pathname *pathname = PATHNAME( classmodel );
	char caption[MAX_STRSIZE];
	char value[MAX_STRSIZE];

	if( !class_get_member_string( root, MEMBER_CAPTION, 
		caption, MAX_STRSIZE ) ||
		!class_get_member_string( root, MEMBER_VALUE, 
			value, MAX_STRSIZE ) )
		return( FALSE );
	iobject_set( IOBJECT( classmodel ), NULL, caption );
	SETSTR( pathname->value, value );

	return( TRUE );
}

/* Make a new "fn value" application.
 */
static gboolean
pathname_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	Pathname *pathname = PATHNAME( classmodel );
	PElement rhs;

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, 
			IOBJECT( classmodel )->caption, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, pathname->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
pathname_class_init( PathnameClass *class )
{
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = pathnameview_new;
	model_class->edit = pathname_edit;
	model_class->save = pathname_save;
	model_class->load = pathname_load;

	classmodel_class->class_get = pathname_class_get;
	classmodel_class->class_new = pathname_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
pathname_init( Pathname *pathname )
{
	/* Overridden later. Just something sensible.
	 */
	pathname->value = NULL;

	iobject_set( IOBJECT( pathname ), CLASS_PATHNAME, NULL );
}

GType
pathname_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( PathnameClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) pathname_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Pathname ),
			32,             /* n_preallocs */
			(GInstanceInitFunc) pathname_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"Pathname", &info, 0 );
	}

	return( type );
}

Classmodel *
pathname_new( Rhs *rhs )
{
	Pathname *pathname;

	pathname = PATHNAME( g_object_new( TYPE_PATHNAME, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( pathname ), -1 );

	return( CLASSMODEL( pathname ) );
}
