/* Declarations for ruler module.
 */

/* Global variables associated with rulers.
 */
extern GC ruler_gc;		/* Paint ruler marks with this */
extern GC tick_gc;		/* GC we use to draw animated ticks */
extern XFontStruct *ruler_font;	/* Font for labeling rulers */

/* Ruler orientation.
 */
typedef enum ruler_angle {
	RULER_HORIZONTAL,	/* Left-IM_RECT_RIGHT */
	RULER_VERTICAL		/* Top-IM_RECT_BOTTOM */
} RulerAngle;

/* A ruler: we need to track the area currently being shown, the way we are
 * showing it (how many divisions etc.), and where we are showing it.
 */
typedef struct ruler_info {
	struct display *scr;	/* Link back to display struct */
	Bool enabled;		/* On/off */
	RulerAngle type;	/* Horizontal/vertical */
	Widget draw;		/* DrawingArea we render into */
	int from;		/* Start of pixels we are showing */
	int space;		/* Space we are showing these pixels in */
	float ppm;		/* Pixels-per-millimetre */
	float pxsep;		/* Mark separation in pixels */
	int width;		/* Minor direction space */
	Rect tarea;		/* Typical text size: used for layout */
	Bool tick;		/* Tick visible */
	int tpos;		/* Tick position */
} RulerInfo;

/* Make new ruler 
 */
extern RulerInfo *build_ruler( Widget par, struct display *scr, RulerAngle type 
);

/* Remove a ruler and its store.
 */
extern void destroy_ruler( RulerInfo *rule );

/* Scroll cleverly to new place 
 */
extern void scroll_ruler( RulerInfo *rule, int left, int top );
extern void update_rulers( struct display *scr );

/* Rejig ruler variables on change 
 */
extern void rethink_ruler( RulerInfo *rule );

/* Remove from image display window 
 */
extern void hide_rulers( struct display *scr );

/* Add to image display window 
 */
extern void show_rulers( struct display *scr );

/* Animate cursor position ticks 
 */
extern void update_ticks(
	struct display *scr, 
	int x, 			/* New x, y position */
	int y 
);

/* Force complete repaint 
 */
extern void force_ruler_repaint( RulerInfo *rule );

/* Set resolution and refresh.
 */
extern Bool set_ruler_ppm( RulerInfo *rule, double ppm );

/* Read current resolution.
 */
extern double get_ruler_ppm( RulerInfo *rule );
