# -*- python -*-

from twisted.application import service
from twisted.application import internet

from nevow import appserver
from nevow import loaders
from nevow import rend
from nevow import tags

from formless import annotate
from formless import webform


class IMyForm(annotate.TypedInterface):
    foo = annotate.Integer()

    def bar(self, baz=annotate.Integer()):
        pass
    bar = annotate.autocallable(bar)


class Implementation(object):
    __implements__ = IMyForm,

    foo = 5

    def bar(self, baz):
        print "baz!", baz


class FormPage(rend.Page):

    addSlash = True

    child_webform_css = webform.defaultCSS

    docFactory = loaders.stan(
        tags.html[
            tags.head[
                tags.link(rel='stylesheet', type='text/css', href='/webform_css'),
                ],
            tags.body[
                "Hello! Here is a form:",

                # We want to render forms defined by the Implementation instance.
                # When we pass the Implementation instance to FormPage below,
                # rend.Page sets it as the .original attribute. To tell webform to render
                # forms described by this object, we use the configurable name "original".
                webform.renderForms('original'),
                ],
            ],
        )


application = service.Application("formpost2")
internet.TCPServer(
    8080, 
    appserver.NevowSite(
        FormPage(Implementation())
    )
).setServiceParent(application)
