/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#include <myx_public_interface.h>
#include <myx_grt_public_interface.h>
#include <myx_grt_builtin_module_public_interface.h>

#include "myx_grt_mysql_reveng.h"
#include "myx_grt_mysql_transformation.h"

static MYX_GRT_BUILTIN_FUNCTION functions_reverse_engineer[]= {
  {"getSchemata::", get_schema_list },
  {"reverseEngineer::", get_schema_assets },
};

static MYX_GRT_BUILTIN_MODULE grt_module_reverse_engineer_mysql= {
  "ReverseEngineeringMysql",
  NULL,
  sizeof(functions_reverse_engineer)/sizeof(MYX_GRT_BUILTIN_FUNCTION),
  functions_reverse_engineer
};

static MYX_GRT_BUILTIN_FUNCTION functions_transformation[]= {
  {"generateSqlCreateStatements::", generate_sql_create_statements },
  {"getSqlCreateScript::", get_sql_create_script },
  {"getSqlCreate::", get_sql_create },
  {"getSqlDrop::", get_sql_drop },
  {"getSqlMerge::", get_sql_merge },
};

static MYX_GRT_BUILTIN_MODULE grt_module_transformation_mysql= {
  "TransformationMysql",
  NULL,
  sizeof(functions_transformation)/sizeof(MYX_GRT_BUILTIN_FUNCTION),
  functions_transformation
};


MYX_GRT_ERROR myx_register_builtin_grt_module_reverse_engineer_mysql(MYX_GRT *grt)
{
  return myx_grt_module_register_builtin(grt, &grt_module_reverse_engineer_mysql, grt);
}

MYX_GRT_ERROR myx_register_builtin_grt_module_transformation_mysql(MYX_GRT *grt)
{
  return myx_grt_module_register_builtin(grt, &grt_module_transformation_mysql, grt);
}
