// test_parse_sql_statemets.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "myx_public_interface.h"

void print_usage()
{
  printf("usage : test_parse_sql_statements.exe "
          "use|load|delimiter|exit|help|start|commit|rollback [filename]\n");
}

void process_text_res(const char * text, char * res)
{
  printf("%s\n------------------------------------------------------>\n",text);
  if (!res)
  {
    printf("<null>\n------------------------------------------------------\n");
  }
  else
  {
    printf("%s\n------------------------------------------------------\n",res);
    myx_free_lib_str(res);
  }
}

void process_int_res(const char * text, int res)
{
  printf("%s\n------------------------------------------------>%d\n",text,res);  
}

void test(const char * tag, const char * text)
{
  if      (!strcmp(tag,"use"))
  {
    process_text_res(text,myx_parse_sqlmemo_command_use(text));
  }
  else if (!strcmp(tag,"load"))
  {
    process_text_res(text,myx_parse_sqlmemo_command_load(text));
  }
  else if (!strcmp(tag,"delimiter"))
  {
    process_text_res(text,myx_parse_sqlmemo_command_delimiter(text));
  }
  else if (!strcmp(tag,"exit"))
  {
    process_int_res(text,myx_parse_sqlmemo_command_exit(text));
  }
  else if (!strcmp(tag,"help"))
  {
    process_text_res(text,myx_parse_sqlmemo_command_help(text));
  }
  else if (!strcmp(tag,"start"))
  {
    process_int_res(text,myx_parse_sqlmemo_command_transaction_start(text));
  }
  else if (!strcmp(tag,"commit"))
  {
    process_int_res(text,myx_parse_sqlmemo_command_transaction_commit(text));
  }
  else if (!strcmp(tag,"rollback"))
  {
    process_int_res(text,myx_parse_sqlmemo_command_transaction_rollback(text));
  }
}

bool read_separator(FILE * file, char * buffer, size_t buffer_size)
{
  while (fgets(buffer,(int)(buffer_size-1),file) &&
         (buffer[0] == '\r' || buffer[0] == '\n'));
  return buffer[0] != '\r' && buffer[0] != '\n' && buffer[0]!=0;
}

size_t prepare_line(char * line, size_t len)
{
  if (line)
  {
    while (len && (line[len-1]=='\r' || line[len-1]=='\n'))
      line[--len]= 0;
  }
  return len;
}

size_t read_text_till_separator(FILE * file,
                                char * text_buffer, size_t text_buffer_size,
                                char * line_buffer, size_t line_buffer_size,
                                const char * separator, size_t separator_len)
{
  text_buffer[0]= 0;
  size_t text_len= 0;
  while (fgets(line_buffer,(int)(line_buffer_size-1),file))
  {
    size_t line_len= strlen(line_buffer);
    if (separator_len==line_len && !strncmp(line_buffer,separator,line_len))
      break;
    if (line_len + text_len < text_buffer_size)
    {
      strcat(text_buffer+text_len,line_buffer);
      text_len += line_len;
    }
  }
  return prepare_line(text_buffer,text_len);
}

char separator_buffer [255];
char line_buffer      [255];
char query_buffer     [10000];

void test(const char * tag, FILE * file)
{
  while (!feof(file))
  {
    if (read_separator(file,separator_buffer,sizeof(separator_buffer)) &&
        read_text_till_separator(file,
                                 query_buffer,sizeof(query_buffer),
                                 line_buffer,sizeof(line_buffer),
                                 separator_buffer,strlen(separator_buffer)))
    {
      test(tag,query_buffer);
    }
  }
}

int main(int argc, char * argv[])
{
  if (argc<2)
    print_usage();
  else
  {
    if (argc==2)
      test(argv[1],stdin);
    else
    {
      FILE * file= fopen(argv[2],"r");
      if (!file)
      {
        printf("can't open file \"%s\" !\n",argv[2]);
      }
      else
      {
        test(argv[1],file);
        fclose(file);
      }
    }
  }
	return 0;
}

