/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 rcobject.h  -  A reference counting object class, including smartpointer.

    begin                : Sun Jan 6 2002
    copyright            : (C) 2002 by 
    email                : 
 ***************************************************************************/

#ifndef RCOBJECT_H
#define RCOBJECT_H

#ifdef _REENTRANT
#include "mthread.h"
#endif //_REENTRANT

class MRCObject {
public: 
	MRCObject();
	MRCObject(bool bRecursive); // this will optionally construct a recursive mutex
protected:
	virtual ~MRCObject() = 0;
public:
	// references
	inline void AddRef(){
#	ifdef _REENTRANT
	m_mutex.lock();
#	endif //_REENTRANT
	++m_nRefs;
#	ifdef _REENTRANT
	m_mutex.unlock();
#	endif //_REENTRANT
	}
	inline void Release(){
#	ifdef _REENTRANT
	m_mutex.lock();
#	endif //_REENTRANT
	ASSERT(m_nRefs>0);
	if (--m_nRefs<=0)
	{
#		ifdef _REENTRANT
		m_mutex.unlock();
#		endif //_REENTRANT
		delete this;
		return;
	}
#	ifdef _REENTRANT
	m_mutex.unlock();
#	endif //_REENTRANT
	}
	inline int GetRefs(){
		return m_nRefs;
	}
protected:
	int m_nRefs;
#	ifdef _REENTRANT
	MMutex m_mutex;
#	endif //_REENTRANT
};

template<class T>
class TSmartPtr {
public:
	TSmartPtr(T* ptr = NULL) : m_ptr(ptr){
		if (m_ptr)
			m_ptr->AddRef();
	}
	TSmartPtr(const TSmartPtr<T>& sptr){
		if (sptr.m_ptr)
			sptr.m_ptr->AddRef();
		m_ptr = sptr.m_ptr;
	}
	~TSmartPtr(){
		if (m_ptr)
			m_ptr->Release();
	}
	// operators
	T* operator=(T* ptr){
		if (ptr)
			ptr->AddRef();
		if (m_ptr)
			m_ptr->Release();
		m_ptr = ptr;
		return m_ptr;
	}
	T* operator=(const TSmartPtr<T>& sptr){
		if (sptr.m_ptr)
			sptr.m_ptr->AddRef();
		if (m_ptr)
			m_ptr->Release();
		m_ptr = sptr.m_ptr;
		return m_ptr;
	}
	operator const T*() const { return m_ptr; }
	operator T*() { return m_ptr; }
	T& operator*() const { return *m_ptr; }
	T* operator->() const { return m_ptr; }
private:
	T* m_ptr;
};

#endif

